/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.console;

class ConsoleWord {
    public final String word;
    public final int startPosition;
    public final int endPosition;

    ConsoleWord(String word, int startPosition, int endPosition) {
        this.word = word;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    ConsoleWord getWordWithoutSpecialCharacters() {
        StringBuilder buffy = new StringBuilder(this.word);
        int newEndPosition = this.endPosition;
        while (buffy.length() > 0 && this.isSpecialChar(buffy.charAt(buffy.length() - 1))) {
            buffy.deleteCharAt(buffy.length() - 1);
            --newEndPosition;
        }
        int newStartPosition = this.startPosition;
        while (buffy.length() > 0 && this.isSpecialChar(buffy.charAt(0))) {
            buffy.deleteCharAt(0);
            ++newStartPosition;
        }
        return new ConsoleWord(buffy.toString(), newStartPosition, newEndPosition);
    }

    private boolean isSpecialChar(char c) {
        return c == ']' || c == '[' || c == ',' || c == '.';
    }

    public String toString() {
        return this.word + "(" + this.startPosition + "," + this.endPosition + ")";
    }
}

