/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace.data;

import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.trace.data.AbstractPcodeTraceDataAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceRegistersAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.property.TracePropertyMap;
import ghidra.trace.model.property.TracePropertyMapSpace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceRegisterUtils;

public class DefaultPcodeTraceRegistersAccess
extends AbstractPcodeTraceDataAccess
implements PcodeTraceRegistersAccess {
    protected final TraceThread thread;
    protected final int frame;
    protected TraceMemorySpace ms;

    protected DefaultPcodeTraceRegistersAccess(TracePlatform platform, long snap, TraceThread thread, int frame, TraceTimeViewport viewport) {
        super(platform, snap, viewport);
        this.thread = thread;
        this.frame = frame;
        this.ms = this.mm.getMemoryRegisterSpace(thread, frame, false);
    }

    @Override
    protected TraceMemorySpace getMemoryOps(boolean createIfAbsent) {
        if (this.ms == null) {
            this.ms = this.mm.getMemoryRegisterSpace(this.thread, this.frame, createIfAbsent);
            return this.ms;
        }
        return this.ms;
    }

    public <T> TracePropertyMapSpace<T> getPropertyOps(String name, Class<T> type, boolean createIfAbsent) {
        if (createIfAbsent) {
            return this.platform.getTrace().getAddressPropertyManager().getOrCreatePropertyMap(name, type).getPropertyMapRegisterSpace(this.thread, this.frame, createIfAbsent);
        }
        TracePropertyMap<T> map = this.platform.getTrace().getAddressPropertyManager().getPropertyMap(name, type);
        return map == null ? null : map.getPropertyMapRegisterSpace(this.thread, this.frame, createIfAbsent);
    }

    protected boolean isRegisterKnown(PcodeThread<?> thread, Register register) {
        Trace trace = this.platform.getTrace();
        TraceThread traceThread = trace.getThreadManager().getLiveThreadByPath(this.snap, thread.getName());
        TraceMemorySpace space = trace.getMemoryManager().getMemoryRegisterSpace(traceThread, false);
        if (space == null) {
            return false;
        }
        return space.getState(this.platform, this.snap, register) == TraceMemoryState.KNOWN;
    }

    @Override
    public void initializeThreadContext(PcodeThread<?> thread) {
        RegisterValue context;
        Trace trace = this.platform.getTrace();
        Language language = this.platform.getLanguage();
        Register contextreg = language.getContextBaseRegister();
        if (contextreg != Register.NO_CONTEXT && !this.isRegisterKnown(thread, contextreg) && (context = trace.getRegisterContextManager().getValueWithDefault(this.platform, contextreg, this.snap, thread.getCounter())) != null) {
            thread.overrideContext(context);
        }
    }

    @Override
    protected Address toOverlay(Address address) {
        TraceMemorySpace ops = this.getMemoryOps(false);
        if (ops == null) {
            return null;
        }
        return ops.getAddressSpace().getOverlayAddress(address);
    }

    @Override
    protected AddressRange toOverlay(AddressRange range) {
        TraceMemorySpace ops = this.getMemoryOps(false);
        if (ops == null) {
            return null;
        }
        AddressSpace space = ops.getAddressSpace();
        return TraceRegisterUtils.getOverlayRange(space, range);
    }

    @Override
    protected AddressSetView toOverlay(AddressSetView set) {
        TraceMemorySpace ops = this.getMemoryOps(false);
        if (ops == null) {
            return null;
        }
        AddressSpace space = ops.getAddressSpace();
        return TraceRegisterUtils.getOverlaySet(space, set);
    }
}

