/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import generic.concurrent.QItemListener;
import ghidra.util.task.TaskMonitor;
import java.util.LinkedList;
import java.util.Queue;

public class ConcurrentQBuilder<I, R> {
    private Queue<I> queue;
    private String threadPoolName;
    private GThreadPool threadPool;
    private QItemListener<I, R> listener;
    private boolean collectResults;
    private int maxInProgress;
    private boolean jobsReportProgress = false;
    private TaskMonitor monitor = TaskMonitor.DUMMY;
    private boolean cancelClearsAllJobs = true;

    public ConcurrentQBuilder<I, R> setQueue(Queue<I> queue) {
        this.queue = queue;
        return this;
    }

    public ConcurrentQBuilder<I, R> setMaxInProgress(int max) {
        this.maxInProgress = max;
        return this;
    }

    public ConcurrentQBuilder<I, R> setThreadPoolName(String name) {
        this.threadPoolName = name;
        return this;
    }

    public ConcurrentQBuilder<I, R> setThreadPool(GThreadPool threadPool) {
        this.threadPool = threadPool;
        return this;
    }

    public ConcurrentQBuilder<I, R> setCollectResults(boolean collectResults) {
        this.collectResults = collectResults;
        return this;
    }

    public ConcurrentQBuilder<I, R> setJobsReportProgress(boolean reportsProgress) {
        this.jobsReportProgress = reportsProgress;
        return this;
    }

    public ConcurrentQBuilder<I, R> setListener(QItemListener<I, R> listener) {
        this.listener = listener;
        return this;
    }

    public ConcurrentQBuilder<I, R> setMonitor(TaskMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public ConcurrentQBuilder<I, R> setCancelClearsAllJobs(boolean clearAllJobs) {
        this.cancelClearsAllJobs = clearAllJobs;
        return this;
    }

    public ConcurrentQ<I, R> build(QCallback<I, R> callback) {
        ConcurrentQ<I, R> concurrentQ = new ConcurrentQ<I, R>(callback, this.getQueue(), this.getThreadPool(), this.listener, this.collectResults, this.maxInProgress, this.jobsReportProgress);
        if (this.monitor != null) {
            concurrentQ.setMonitor(this.monitor, this.cancelClearsAllJobs);
        }
        return concurrentQ;
    }

    private GThreadPool getThreadPool() {
        if (this.threadPool != null) {
            return this.threadPool;
        }
        if (this.threadPoolName != null) {
            return GThreadPool.getPrivateThreadPool((String)this.threadPoolName);
        }
        throw new IllegalStateException("Must either set a GThreadPool or set a thread pool name");
    }

    private Queue<I> getQueue() {
        if (this.queue != null) {
            return this.queue;
        }
        return new LinkedList();
    }
}

