/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.wizard.project;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import generic.theme.GIcon;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.main.wizard.project.ProjectAccessStep;
import ghidra.framework.main.wizard.project.ProjectWizardData;
import ghidra.framework.main.wizard.project.RepositoryStep;
import ghidra.framework.main.wizard.project.ServerStep;
import ghidra.framework.model.ServerInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UserAccessException;
import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;

public class ProjectChooseRepositoryWizardModel
extends WizardModel<ProjectWizardData> {
    private static final Icon CONVERT_ICON = new GIcon("icon.project.info.convert");
    private PluginTool tool;

    public ProjectChooseRepositoryWizardModel(PluginTool tool, String title) {
        this(tool, title, null);
    }

    public ProjectChooseRepositoryWizardModel(PluginTool tool, String title, ServerInfo server) {
        super(title, (Object)new ProjectWizardData(), CONVERT_ICON);
        this.tool = tool;
        ((ProjectWizardData)this.data).setIsSharedProject(true);
        ((ProjectWizardData)this.data).setServerInfo(server);
    }

    protected void addWizardSteps(List<WizardStep<ProjectWizardData>> steps) {
        steps.add(new ServerStep(this, this.tool.getProjectManager()));
        steps.add(new RepositoryStep(this));
        steps.add(new ProjectAccessStep(this, this.tool));
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 300);
    }

    protected boolean doFinish() {
        RepositoryAdapter repository = this.getOrCreateRepository();
        if (repository == null) {
            return false;
        }
        try {
            repository.connect();
        }
        catch (IOException e) {
            this.setStatusMessage("Can't connect to repository: " + ((ProjectWizardData)this.data).getRepositoryName());
            return false;
        }
        ((ProjectWizardData)this.data).setRepository(repository);
        return true;
    }

    public void cancel() {
        RepositoryAdapter repository = ((ProjectWizardData)this.data).getRepository();
        if (repository != null) {
            repository.disconnect();
            ((ProjectWizardData)this.data).setRepository(null);
        }
        ((ProjectWizardData)this.data).setServer(null);
    }

    private RepositoryAdapter getOrCreateRepository() {
        String repositoryName = ((ProjectWizardData)this.data).getRepositoryName();
        RepositoryServerAdapter server = ((ProjectWizardData)this.data).getServer();
        if (!((ProjectWizardData)this.data).isNewRepository()) {
            RepositoryAdapter repository = server.getRepository(repositoryName);
            if (repository == null) {
                this.setStatusMessage("Can't open repository: " + repositoryName);
            }
            return repository;
        }
        try {
            RepositoryAdapter repository = server.createRepository(repositoryName);
            repository.setUserList(((ProjectWizardData)this.data).getProjectUsers(), ((ProjectWizardData)this.data).allowAnonymousAccess());
            return repository;
        }
        catch (DuplicateNameException e) {
            this.setStatusMessage("Repository " + repositoryName + " exists");
        }
        catch (UserAccessException exc) {
            this.setStatusMessage("Could not update the user list: " + exc.getMessage());
        }
        catch (NotConnectedException e) {
            Object statusMessage = e.getMessage();
            if (statusMessage == null) {
                String serverName = ((ProjectWizardData)this.data).getServerInfo().getServerName();
                statusMessage = "Not connected to server " + serverName;
            }
            this.setStatusMessage((String)statusMessage);
        }
        catch (IOException e) {
            this.setStatusMessage("Error occurred while updating the user list: " + e.getMessage());
        }
        return null;
    }

    public RepositoryAdapter getRepository() {
        return ((ProjectWizardData)this.data).getRepository();
    }
}

