/*
 * Decompiled with CFR 0.152.
 */
package datagraph.data.graph.panel.model.column;

import datagraph.data.graph.panel.model.column.PointerColumnRenderer;
import datagraph.data.graph.panel.model.column.ValueColumnRenderer;
import datagraph.data.graph.panel.model.row.DataRowObject;
import docking.widgets.trable.GTrableCellRenderer;
import docking.widgets.trable.GTrableColumn;
import docking.widgets.trable.GTrableColumnModel;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CompactDataColumnModel
extends GTrableColumnModel<DataRowObject> {
    protected void populateColumns(List<GTrableColumn<DataRowObject, ?>> columnList) {
        columnList.add(new NameColumn(this));
        columnList.add(new ValueColumn(this));
        columnList.add(new PointerButtonColumn());
    }

    public boolean isPointerButtonColumn(int column) {
        return column == 2;
    }

    private class NameColumn
    extends GTrableColumn<DataRowObject, String> {
        private NameColumn(CompactDataColumnModel compactDataColumnModel) {
        }

        public String getValue(DataRowObject row) {
            if (row.getIndentLevel() == 0) {
                return row.getDataType();
            }
            return row.getName();
        }

        protected int getPreferredWidth() {
            return 150;
        }
    }

    private class ValueColumn
    extends GTrableColumn<DataRowObject, String> {
        private GTrableCellRenderer<String> renderer = new ValueColumnRenderer();

        private ValueColumn(CompactDataColumnModel compactDataColumnModel) {
        }

        public String getValue(DataRowObject row) {
            Object value = row.getValue();
            if (!StringUtils.isBlank((CharSequence)value)) {
                value = " = " + (String)value;
            } else if (row.getIndentLevel() > 0) {
                value = "    " + row.getDataType();
            }
            return value;
        }

        protected int getPreferredWidth() {
            return 100;
        }

        public GTrableCellRenderer<String> getRenderer() {
            return this.renderer;
        }
    }

    private static class PointerButtonColumn
    extends GTrableColumn<DataRowObject, Boolean> {
        private GTrableCellRenderer<Boolean> renderer = new PointerColumnRenderer();

        private PointerButtonColumn() {
        }

        public Boolean getValue(DataRowObject row) {
            return row.hasOutgoingReferences();
        }

        protected int getPreferredWidth() {
            return 24;
        }

        public boolean isResizable() {
            return false;
        }

        public GTrableCellRenderer<Boolean> getRenderer() {
            return this.renderer;
        }
    }

    private static class TypeColumn
    extends GTrableColumn<DataRowObject, String> {
        private TypeColumn() {
        }

        public String getValue(DataRowObject row) {
            return row.getDataType();
        }

        protected int getPreferredWidth() {
            return 120;
        }
    }
}

