/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout;

import generic.theme.GIcon;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.DNLayoutOptions;
import ghidra.app.plugin.core.functiongraph.graph.layout.DecompilerNestedLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutOptions;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProviderExtensionPoint;
import ghidra.framework.options.Options;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;

public class DecompilerNestedLayoutProvider
extends FGLayoutProviderExtensionPoint {
    private static final Icon ICON = new GIcon("icon.plugin.functiongraph.layout.nested.code");
    static final String LAYOUT_NAME = "Nested Code Layout";

    public FGLayout getFGLayout(FunctionGraph graph, TaskMonitor monitor) {
        DecompilerNestedLayout layout = new DecompilerNestedLayout(graph, LAYOUT_NAME);
        layout.setTaskMonitor(monitor);
        return layout;
    }

    public FGLayoutOptions createLayoutOptions(Options options) {
        DNLayoutOptions layoutOptions = new DNLayoutOptions();
        layoutOptions.registerOptions(options);
        return layoutOptions;
    }

    public String getLayoutName() {
        return LAYOUT_NAME;
    }

    public Icon getActionIcon() {
        return ICON;
    }

    public int getPriorityLevel() {
        return 200;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("FunctionGraphPlugin", "Nested_Code_Layout");
    }
}

