/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContext;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLEntityResolver;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLVariable;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SQLAttributeResolver
extends TemplateVariableResolver {
    private static final Log log = Log.getLog(SQLAttributeResolver.class);

    public SQLAttributeResolver() {
        super("column", "Table column");
    }

    protected String[] resolveAll(final TemplateContext context) {
        String tableName;
        final DBCExecutionContext executionContext = ((DBPContextProvider)context).getExecutionContext();
        if (executionContext == null) {
            return super.resolveAll(context);
        }
        SQLVariable tableVariable = ((SQLContext)context).getTemplateVariable("table");
        String string = tableName = tableVariable == null ? null : tableVariable.getDefaultValue();
        if (!CommonUtils.isEmpty((String)tableName)) {
            final ArrayList attributes = new ArrayList();
            DBRRunnableWithProgress runnable = new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DBSEntity table;
                        ArrayList<DBSEntity> entities = new ArrayList<DBSEntity>();
                        SQLEntityResolver.resolveTables(monitor, executionContext, context, entities);
                        if (!CommonUtils.isEmpty(entities) && (table = (DBSEntity)DBUtils.findObject(entities, (String)tableName)) != null) {
                            attributes.addAll(CommonUtils.safeCollection((Collection)table.getAttributes(monitor)));
                        }
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            RuntimeUtils.runTask((DBRRunnableWithProgress)runnable, (String)"Resolve attributes", (long)1000L);
            if (!CommonUtils.isEmpty(attributes)) {
                String[] result = new String[attributes.size()];
                for (int i = 0; i < attributes.size(); ++i) {
                    DBSEntityAttribute entity = (DBSEntityAttribute)attributes.get(i);
                    result[i] = entity.getName();
                }
                return result;
            }
        }
        return super.resolveAll(context);
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        super.resolve(variable, context);
        if (variable instanceof SQLVariable) {
            ((SQLVariable)variable).setResolver(this);
        }
    }
}

