/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.utils.CommonUtils;

public class DBNDatabaseObject
extends DBNDatabaseNode
implements DBSObject {
    private final DBXTreeObject meta;

    DBNDatabaseObject(@NotNull DBNNode parent, @NotNull DBXTreeObject meta) {
        super(parent);
        this.meta = meta;
        this.registerNode();
    }

    @Override
    public <T> T getAdapter(@NotNull Class<T> adapter) {
        if (adapter == DBSObject.class) {
            DBSObject databaseObject = this.getObject();
            return adapter.cast(databaseObject);
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected void dispose(boolean reflect) {
        this.unregisterNode(reflect);
        super.dispose(reflect);
    }

    @Override
    @NotNull
    public DBXTreeObject getMeta() {
        return this.meta;
    }

    @Override
    protected boolean reloadObject(@NotNull DBRProgressMonitor monitor, DBSObject object) {
        return false;
    }

    @Override
    @Nullable
    public DBSObject getObject() {
        return this;
    }

    @Override
    public Object getValueObject() {
        return this;
    }

    @Override
    @NotNull
    public String getNodeFullName() {
        StringBuilder pathName = new StringBuilder();
        for (DBNNode parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            String parentName;
            if (parent instanceof DBNDatabaseFolder || CommonUtils.isEmpty((String)(parentName = parent.getNodeDisplayName()))) continue;
            if (!pathName.isEmpty()) {
                pathName.insert(0, '.');
            }
            pathName.insert(0, parentName);
        }
        pathName.insert(0, this.getNodeDisplayName() + " (");
        pathName.append(")");
        return pathName.toString();
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.meta.getNodeTypeLabel(this.getDataSource(), null);
    }

    @Override
    @NotNull
    public String getLocalizedName(@NotNull String locale) {
        return this.meta.getNodeTypeLabel(this.getDataSource(), locale);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.meta.getDescription();
    }

    @Override
    public DBSObject getParentObject() {
        return this.getParentNode() instanceof DBNDatabaseNode ? ((DBSWrapper)((Object)this.getParentNode())).getObject() : null;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        DBSObject parentObject = this.getParentObject();
        if (parentObject == null) {
            throw new IllegalStateException("No parent database object for object node");
        }
        return parentObject.getDataSource();
    }
}

