/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.css;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.UIUtils;

public class CSSUtils {
    public static final String COLORED_BY_CONNECTION_TYPE = "coloredByConnectionType";
    public static final String EXCLUDED_FROM_STYLING = "excludedFromStyling";
    public static final String DATABASE_EDITOR_COMPOSITE_DATASOURCE = "databaseEditorCompositeBackground";

    public static String getCSSClass(Widget widget) {
        return (String)widget.getData("org.eclipse.e4.ui.css.CssClassName");
    }

    public static void setCSSClass(Widget widget, String value) {
        widget.setData("org.eclipse.e4.ui.css.CssClassName", (Object)value);
    }

    public static boolean isExcludeFromStyling(Widget widget) {
        return widget.getData(EXCLUDED_FROM_STYLING) == Boolean.TRUE;
    }

    public static void setExcludeFromStyling(Widget widget) {
        widget.setData(EXCLUDED_FROM_STYLING, (Object)Boolean.TRUE);
    }

    public static void markConnectionTypeColor(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.setData("org.eclipse.e4.ui.css.CssClassName", (Object)COLORED_BY_CONNECTION_TYPE);
        }
    }

    public static Color getCurrentEditorConnectionColor(Widget widget) {
        if (!(widget instanceof Control)) {
            return null;
        }
        Control control = (Control)widget;
        try {
            for (Control c = control; c != null; c = c.getParent()) {
                Object data = c.getData(DATABASE_EDITOR_COMPOSITE_DATASOURCE);
                if (!(data instanceof DBPDataSourceContainer)) continue;
                DBPDataSourceContainer dsc = (DBPDataSourceContainer)data;
                return UIUtils.getConnectionColor(dsc.getConnectionConfiguration());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isDatabaseColored(Widget widget) {
        Composite c;
        Composite composite;
        boolean colorByConnectionType = COLORED_BY_CONNECTION_TYPE.equals(CSSUtils.getCSSClass(widget));
        if (!colorByConnectionType && widget instanceof Composite && (composite = (c = (Composite)widget).getParent()) instanceof ToolBar) {
            ToolBar tb = (ToolBar)composite;
            colorByConnectionType = COLORED_BY_CONNECTION_TYPE.equals(CSSUtils.getCSSClass((Widget)tb));
        }
        return colorByConnectionType;
    }
}

