/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette;

import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.customize.PaletteSettingsDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InternalPaletteSettingsDialog
extends PaletteSettingsDialog {
    protected static final String CACHE_SCROLLBARS_MODE = "scrollbars mode";
    protected static final int SCROLLBARS_MODE_ID = 1039;
    private final PaletteViewerPreferences prefs;

    public InternalPaletteSettingsDialog(Shell parentShell, PaletteViewerPreferences prefs) {
        super(parentShell, prefs);
        this.prefs = prefs;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (Platform.getOS().equals("linux")) {
            Label separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            Control child = this.createScrollbarsSettings(composite);
            child.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        }
        return composite;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        if (1039 == buttonId) {
            Button b = this.getButton(buttonId);
            this.handleScrollbarsModeChanged(b.getSelection());
        } else {
            super.buttonPressed(buttonId);
        }
    }

    @Override
    protected void cacheSettings() {
        super.cacheSettings();
        this.settings.put(CACHE_SCROLLBARS_MODE, this.prefs.getScrollbarsMode());
    }

    @Override
    protected void restoreSettings() {
        super.restoreSettings();
        this.prefs.setScrollbarsMode((Integer)this.settings.get(CACHE_SCROLLBARS_MODE));
    }

    protected Control createScrollbarsSettings(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label label = new Label(composite, 0);
        label.setText(GEFMessages.Settings_OverlayScrolling_Group);
        Button button = this.createButton(composite, 1039, GEFMessages.Settings_OverlayScrolling, 32, null);
        button.setSelection(this.prefs.getScrollbarsMode() == 2);
        return composite;
    }

    protected void handleScrollbarsModeChanged(boolean checked) {
        this.prefs.setScrollbarsMode(checked ? 2 : 0);
    }
}

