﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fms/FMS_EXPORTS.h>
#include <aws/fms/model/ActionTarget.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FMS {
namespace Model {

/**
 * <p>The action of associating an EC2 resource, such as a subnet or internet
 * gateway, with a route table.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/EC2AssociateRouteTableAction">AWS
 * API Reference</a></p>
 */
class EC2AssociateRouteTableAction {
 public:
  AWS_FMS_API EC2AssociateRouteTableAction() = default;
  AWS_FMS_API EC2AssociateRouteTableAction(Aws::Utils::Json::JsonView jsonValue);
  AWS_FMS_API EC2AssociateRouteTableAction& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>A description of the EC2 route table that is associated with the remediation
   * action.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  EC2AssociateRouteTableAction& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the EC2 route table that is associated with the remediation
   * action.</p>
   */
  inline const ActionTarget& GetRouteTableId() const { return m_routeTableId; }
  inline bool RouteTableIdHasBeenSet() const { return m_routeTableIdHasBeenSet; }
  template <typename RouteTableIdT = ActionTarget>
  void SetRouteTableId(RouteTableIdT&& value) {
    m_routeTableIdHasBeenSet = true;
    m_routeTableId = std::forward<RouteTableIdT>(value);
  }
  template <typename RouteTableIdT = ActionTarget>
  EC2AssociateRouteTableAction& WithRouteTableId(RouteTableIdT&& value) {
    SetRouteTableId(std::forward<RouteTableIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the subnet for the EC2 route table that is associated with the
   * remediation action.</p>
   */
  inline const ActionTarget& GetSubnetId() const { return m_subnetId; }
  inline bool SubnetIdHasBeenSet() const { return m_subnetIdHasBeenSet; }
  template <typename SubnetIdT = ActionTarget>
  void SetSubnetId(SubnetIdT&& value) {
    m_subnetIdHasBeenSet = true;
    m_subnetId = std::forward<SubnetIdT>(value);
  }
  template <typename SubnetIdT = ActionTarget>
  EC2AssociateRouteTableAction& WithSubnetId(SubnetIdT&& value) {
    SetSubnetId(std::forward<SubnetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the gateway to be used with the EC2 route table that is associated
   * with the remediation action.</p>
   */
  inline const ActionTarget& GetGatewayId() const { return m_gatewayId; }
  inline bool GatewayIdHasBeenSet() const { return m_gatewayIdHasBeenSet; }
  template <typename GatewayIdT = ActionTarget>
  void SetGatewayId(GatewayIdT&& value) {
    m_gatewayIdHasBeenSet = true;
    m_gatewayId = std::forward<GatewayIdT>(value);
  }
  template <typename GatewayIdT = ActionTarget>
  EC2AssociateRouteTableAction& WithGatewayId(GatewayIdT&& value) {
    SetGatewayId(std::forward<GatewayIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;

  ActionTarget m_routeTableId;

  ActionTarget m_subnetId;

  ActionTarget m_gatewayId;
  bool m_descriptionHasBeenSet = false;
  bool m_routeTableIdHasBeenSet = false;
  bool m_subnetIdHasBeenSet = false;
  bool m_gatewayIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace FMS
}  // namespace Aws
