#!/usr/bin/env bash

# Sync the integration test files from the template to all the integrations targets.

integration_targets="tests/integration/targets/"
integration_common="tests/integration/common"

# banner
banner() {
  echo "#"
  echo "# DO NOT EDIT THIS FILE! Please edit the files in $integration_common instead."
  echo "#"
}

# copy_file <src> <dest>
copy_file() {
  mkdir -p "$(dirname "$2")"
  banner > "$2"
  cat "$1" >> "$2"
}

for target in "$integration_targets"*; do
  if [[ "$(basename "$target")" = setup_* ]]; then
    continue
  fi
  copy_file "$integration_common"/defaults/main/common.yml "$target"/defaults/main/common.yml
  copy_file "$integration_common"/tasks/main.yml "$target"/tasks/main.yml
done
