/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.tipis;

import java.io.Serializable;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class LazyReplicatedMap<K, V>
extends AbstractReplicatedMap<K, V> {
    private static final long serialVersionUID = 1L;
    private volatile transient Log log;

    public LazyReplicatedMap(AbstractReplicatedMap.MapOwner mapOwner, Channel channel, long l, String string, int n, float f, ClassLoader[] classLoaderArray) {
        super(mapOwner, channel, l, string, n, f, 2, classLoaderArray, true);
    }

    public LazyReplicatedMap(AbstractReplicatedMap.MapOwner mapOwner, Channel channel, long l, String string, int n, ClassLoader[] classLoaderArray) {
        super(mapOwner, channel, l, string, n, 0.75f, 2, classLoaderArray, true);
    }

    public LazyReplicatedMap(AbstractReplicatedMap.MapOwner mapOwner, Channel channel, long l, String string, ClassLoader[] classLoaderArray) {
        super(mapOwner, channel, l, string, 16, 0.75f, 2, classLoaderArray, true);
    }

    public LazyReplicatedMap(AbstractReplicatedMap.MapOwner mapOwner, Channel channel, long l, String string, ClassLoader[] classLoaderArray, boolean bl) {
        super(mapOwner, channel, l, string, 16, 0.75f, 2, classLoaderArray, bl);
    }

    @Override
    protected int getStateMessageType() {
        return 5;
    }

    @Override
    protected int getReplicateMessageType() {
        return 1;
    }

    @Override
    protected Member[] publishEntryInfo(Object object, Object object2) throws ChannelException {
        int n;
        Log log = this.getLog();
        if (!(object instanceof Serializable) || !(object2 instanceof Serializable)) {
            return new Member[0];
        }
        Member[] memberArray = this.getMapMembers();
        int n2 = n = this.getNextBackupIndex();
        Member[] memberArray2 = new Member[]{};
        if (memberArray.length == 0 || n == -1) {
            return memberArray2;
        }
        boolean bl = false;
        do {
            AbstractReplicatedMap.MapMessage mapMessage;
            Member[] memberArray3;
            Member member = memberArray[n2];
            if (++n2 >= memberArray.length) {
                n2 = 0;
            }
            if (member == null) continue;
            try {
                memberArray3 = this.wrap(member);
                mapMessage = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 1, false, (Serializable)object, (Serializable)object2, null, this.channel.getLocalMember(false), memberArray3);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Publishing backup data:" + mapMessage + " to: " + member.getName()));
                }
                UniqueId uniqueId = this.getChannel().send(memberArray3, mapMessage, this.getChannelSendOptions());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Data published:" + mapMessage + " msg Id:" + uniqueId));
                }
                bl = true;
                memberArray2 = memberArray3;
            }
            catch (ChannelException channelException) {
                log.error((Object)sm.getString("lazyReplicatedMap.unableReplicate.backup", object, member, channelException.getMessage()), (Throwable)channelException);
                continue;
            }
            try {
                memberArray3 = this.excludeFromSet(memberArray2, this.getMapMembers());
                if (memberArray3.length <= 0) continue;
                mapMessage = new AbstractReplicatedMap.MapMessage(this.getMapContextName(), 3, false, (Serializable)object, null, null, this.channel.getLocalMember(false), memberArray2);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Publishing proxy data:" + mapMessage + " to: " + Arrays.toNameString(memberArray3)));
                }
                this.getChannel().send(memberArray3, mapMessage, this.getChannelSendOptions());
            }
            catch (ChannelException channelException) {
                log.error((Object)sm.getString("lazyReplicatedMap.unableReplicate.proxy", object, member, channelException.getMessage()), (Throwable)channelException);
            }
        } while (!bl && n != n2);
        return memberArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Log getLog() {
        if (this.log == null) {
            LazyReplicatedMap lazyReplicatedMap = this;
            synchronized (lazyReplicatedMap) {
                if (this.log == null) {
                    this.log = LogFactory.getLog(LazyReplicatedMap.class);
                }
            }
        }
        return this.log;
    }
}

