# Interface methods for submodule: VideoStream
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate
from ._proxies import TemporalDataObjectProxy as _TemporalDataObjectProxy


# Interface methods for class: VideoStream
class VideoStreamProxy(_TemporalDataObjectProxy):
	@staticmethod
	def GetFrameDimension() -> int:
		""""""
		...

	@staticmethod
	def New():
		""""""
		...

	def Clone(self):
		""""""
		...

	def GetNameOfClass(self):
		""""""
		...

	def SetMinimumBufferSize(self, minimumNumberOfFrames: int) -> None:
		""""""
		...

	def InitializeEmptyFrames(self) -> None:
		""""""
		...

	def GetFrameBuffer(self):
		""""""
		...

	def SetFrameBuffer(self, buffer) -> None:
		""""""
		...

	def GetLargestPossibleSpatialRegionCache(self):
		""""""
		...

	def SetLargestPossibleSpatialRegionCache(self, map) -> None:
		""""""
		...

	def GetRequestedSpatialRegionCache(self):
		""""""
		...

	def SetRequestedSpatialRegionCache(self, map) -> None:
		""""""
		...

	def GetBufferedSpatialRegionCache(self):
		""""""
		...

	def SetBufferedSpatialRegionCache(self, map) -> None:
		""""""
		...

	def GetSpacingCache(self):
		""""""
		...

	def SetSpacingCache(self, map) -> None:
		""""""
		...

	def GetOriginCache(self):
		""""""
		...

	def SetOriginCache(self, map) -> None:
		""""""
		...

	def GetDirectionCache(self):
		""""""
		...

	def SetDirectionCache(self, map) -> None:
		""""""
		...

	@overload
	def GetNumberOfComponentsPerPixelCache(self):
		""""""
		...

	@overload
	def GetNumberOfComponentsPerPixelCache(self, map) -> None:
		""""""
		...

	def SetFrame(self, frameNumber: int, frame) -> None:
		""""""
		...

	def GetFrame(self, frameNumber: int):
		""""""
		...

	def SetFrameLargestPossibleSpatialRegion(self, frameNumber: int, region: ImageRegion) -> None:
		""""""
		...

	def GetFrameLargestPossibleSpatialRegion(self, frameNumber: int) -> ImageRegion:
		""""""
		...

	def SetFrameRequestedSpatialRegion(self, frameNumber: int, region: ImageRegion) -> None:
		""""""
		...

	def GetFrameRequestedSpatialRegion(self, frameNumber: int) -> ImageRegion:
		""""""
		...

	def SetFrameBufferedSpatialRegion(self, frameNumber: int, region: ImageRegion) -> None:
		""""""
		...

	def GetFrameBufferedSpatialRegion(self, frameNumber: int) -> ImageRegion:
		""""""
		...

	def SetFrameSpacing(self, frameNumber: int, spacing: Sequence[float]) -> None:
		""""""
		...

	def GetFrameSpacing(self, frameNumber: int) -> Sequence[float]:
		""""""
		...

	def SetFrameOrigin(self, frameNumber: int, origin: Sequence[float]) -> None:
		""""""
		...

	def GetFrameOrigin(self, frameNumber: int) -> Sequence[float]:
		""""""
		...

	def SetFrameDirection(self, frameNumber: int, direction) -> None:
		""""""
		...

	def GetFrameDirection(self, frameNumber: int):
		""""""
		...

	def SetFrameNumberOfComponentsPerPixel(self, frameNumber: int, n: int) -> None:
		""""""
		...

	def GetFrameNumberOfComponentsPerPixel(self, frameNumber: int) -> int:
		""""""
		...

	def SetAllLargestPossibleSpatialRegions(self, region: ImageRegion) -> None:
		""""""
		...

	def SetAllRequestedSpatialRegions(self, region: ImageRegion) -> None:
		""""""
		...

	def SetAllBufferedSpatialRegions(self, region: ImageRegion) -> None:
		""""""
		...

	def SetAllFramesSpacing(self, spacing: Sequence[float]) -> None:
		""""""
		...

	def SetAllFramesOrigin(self, origin: Sequence[float]) -> None:
		""""""
		...

	def SetAllFramesDirection(self, direction) -> None:
		""""""
		...

	def SetAllFramesNumberOfComponentsPerPixel(self, n: int) -> None:
		""""""
		...

	def Allocate(self) -> None:
		""""""
		...

	def Graft(self, data) -> None:
		""""""
		...

