/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.FPSCounter;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.Version;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0004J\b\u0010\u0018\u001a\u00020\u0014H\u0004J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001eH\u0084\b\u00f8\u0001\u0000J\b\u0010\u001f\u001a\u00020\u0014H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "Lorg/jetbrains/skiko/redrawer/Redrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "graphicsApi", "Lorg/jetbrains/skiko/GraphicsApi;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/GraphicsApi;)V", "isFirstFrameRendered", "", "rendererAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$RendererAnalytics;", "deviceAnalytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics$DeviceAnalytics;", "value", "isDisposed", "()Z", "dispose", "", "onDeviceChosen", "deviceName", "", "onContextInit", "update", "nanoTime", "", "inDrawScope", "body", "Lkotlin/Function0;", "checkDisposed", "skiko"})
@SourceDebugExtension(value={"SMAP\nAWTRedrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 SkiaLayer.awt.kt\norg/jetbrains/skiko/SkiaLayer\n+ 4 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,77:1\n1#2:78\n1#2:80\n611#3:79\n612#3,9:81\n621#3,5:94\n168#4,4:90\n*S KotlinDebug\n*F\n+ 1 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n*L\n66#1:80\n66#1:79\n66#1:81,9\n66#1:94,5\n66#1:90,4\n*E\n"})
public abstract class AWTRedrawer
implements Redrawer {
    @NotNull
    private final SkiaLayer layer;
    @NotNull
    private final SkiaLayerAnalytics analytics;
    @NotNull
    private final GraphicsApi graphicsApi;
    private boolean isFirstFrameRendered;
    @NotNull
    private final SkiaLayerAnalytics.RendererAnalytics rendererAnalytics;
    @Nullable
    private SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics;
    private boolean isDisposed;

    public AWTRedrawer(@NotNull SkiaLayer layer, @NotNull SkiaLayerAnalytics analytics, @NotNull GraphicsApi graphicsApi) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)((Object)graphicsApi), (String)"graphicsApi");
        this.layer = layer;
        this.analytics = analytics;
        this.graphicsApi = graphicsApi;
        this.rendererAnalytics = this.analytics.renderer(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi);
        this.rendererAnalytics.init();
    }

    protected final boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void dispose() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass() + " is disposed";
            throw new IllegalArgumentException(string.toString());
        }
        this.isDisposed = true;
    }

    protected final void onDeviceChosen(@Nullable String deviceName) {
        block1: {
            this.checkDisposed();
            if (!(this.deviceAnalytics == null)) {
                boolean bl = false;
                String string = "deviceAnalytics is not null";
                throw new IllegalArgumentException(string.toString());
            }
            this.rendererAnalytics.deviceChosen();
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics = this.analytics.device(Version.INSTANCE.getSkiko(), OsArch_jvmKt.getHostOs(), this.graphicsApi, deviceName);
            if (deviceAnalytics == null) break block1;
            deviceAnalytics.init();
        }
    }

    protected final void onContextInit() {
        block1: {
            this.checkDisposed();
            if (this.deviceAnalytics == null) {
                boolean bl = false;
                String string = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                throw new IllegalArgumentException(string.toString());
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics == null) break block1;
            deviceAnalytics.contextInit();
        }
    }

    @Override
    public void update(long nanoTime) {
        this.checkDisposed();
        this.layer.update$skiko(nanoTime);
    }

    protected final void inDrawScope(@NotNull Function0<Unit> body) {
        block16: {
            boolean isFirstFrame;
            block15: {
                Intrinsics.checkNotNullParameter(body, (String)"body");
                boolean $i$f$inDrawScope = false;
                if (this.deviceAnalytics == null) {
                    boolean $i$a$-requireNotNull-AWTRedrawer$inDrawScope$22 = false;
                    String $i$a$-requireNotNull-AWTRedrawer$inDrawScope$22 = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                    throw new IllegalArgumentException($i$a$-requireNotNull-AWTRedrawer$inDrawScope$22.toString());
                }
                if (this.isDisposed) break block16;
                isFirstFrame = !this.isFirstFrameRendered;
                this.isFirstFrameRendered = true;
                if (isFirstFrame) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer this_$iv = this.layer;
                boolean $i$f$inDrawScope$skiko = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$1$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$1$iv22 = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$1$iv22.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(this_$iv))) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$2$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$2$iv22 = "SkiaLayer is disposed";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$2$iv22.toString());
                }
                try {
                    FPSCounter fPSCounter = SkiaLayer.access$getFpsCounter$p(this_$iv);
                    if (fPSCounter != null) {
                        fPSCounter.tick();
                    }
                    body.invoke();
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException e$iv) {
                    if (SkiaLayer.access$isDisposed$p(this_$iv)) break block15;
                    Logger this_$iv$iv = Logger.INSTANCE;
                    boolean $i$f$warn = false;
                    if (this_$iv$iv.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = e$iv;
                        SkikoLoggerInterface skikoLoggerInterface = this_$iv$iv.getLoggerImpl();
                        boolean bl = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(this_$iv), false, 1, null);
                    Redrawer redrawer = this_$iv.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.renderImmediately();
                    }
                }
            }
            if (isFirstFrame && !this.isDisposed) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = this.deviceAnalytics;
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
        }
    }

    protected final void checkDisposed() {
        if (!(!this.isDisposed)) {
            boolean bl = false;
            String string = this.getClass().getSimpleName() + " is disposed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public void syncBounds() {
        Redrawer.DefaultImpls.syncBounds(this);
    }

    @Override
    public void setVisible(boolean isVisible) {
        Redrawer.DefaultImpls.setVisible(this, isVisible);
    }
}

