/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.ExpressionStatement;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ThisReferenceExpression;

public class RemoveRedundantInitializersTransform
extends ContextTrackingVisitor<Void> {
    private boolean _inConstructor;

    public RemoveRedundantInitializersTransform(DecompilerContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        boolean wasInConstructor = this._inConstructor;
        this._inConstructor = true;
        try {
            Void void_ = (Void)super.visitConstructorDeclaration(node, p);
            return void_;
        }
        finally {
            this._inConstructor = wasInConstructor;
        }
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression node, Void data) {
        FieldDefinition resolvedField;
        MemberReferenceExpression reference;
        MemberReference memberReference;
        Expression left;
        super.visitAssignmentExpression(node, data);
        if (this._inConstructor && (left = node.getLeft()) instanceof MemberReferenceExpression && ((MemberReferenceExpression)left).getTarget() instanceof ThisReferenceExpression && (memberReference = (reference = (MemberReferenceExpression)left).getUserData(Keys.MEMBER_REFERENCE)) instanceof FieldReference && (resolvedField = ((FieldReference)memberReference).resolve()) != null && resolvedField.hasConstantValue()) {
            AstNode parent = node.getParent();
            if (parent instanceof ExpressionStatement) {
                parent.remove();
            } else {
                reference.remove();
                node.replaceWith(reference);
            }
        }
        return null;
    }
}

