/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.color;

import com.plantuml.ubrex.builder.UBrexLeaf;
import com.plantuml.ubrex.builder.UBrexNamed;
import com.plantuml.ubrex.builder.UBrexPart;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.RegexResult;

public class UBrexColorParser {
    private static final String COLOR_REGEXP = "# \u3007+\u3034w \u3007?\u3018 \u300c-\\|/\u300d \u3007+\u3034w \u3019";
    private final UBrexPart regex;
    private final String name;
    private final ColorType mainType;

    private UBrexColorParser(String name, UBrexPart regex, ColorType mainType) {
        this.regex = regex;
        this.name = name;
        this.mainType = mainType;
    }

    public Colors getColor(RegexResult arg, HColorSet set) throws NoSuchColorException {
        if (this.mainType == null) {
            throw new IllegalStateException();
        }
        String data = arg.getLazzy(this.name, 0);
        if (data == null) {
            return Colors.empty();
        }
        return new Colors(data, set, this.mainType);
    }

    public static UBrexColorParser simpleColor(ColorType mainType) {
        return UBrexColorParser.simpleColor(mainType, "COLOR");
    }

    public static UBrexColorParser simpleColor(ColorType mainType, String id) {
        return new UBrexColorParser(id, new UBrexNamed(id, new UBrexLeaf(COLOR_REGEXP)), mainType);
    }

    public UBrexPart getRegex() {
        return this.regex;
    }
}

