/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.transfer;

import lombok.Generated;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.transfer.OffHeapBinaryVectorTransfer;
import org.opensearch.knn.index.codec.transfer.OffHeapByteVectorTransfer;
import org.opensearch.knn.index.codec.transfer.OffHeapFloatVectorTransfer;
import org.opensearch.knn.index.codec.transfer.OffHeapVectorTransfer;

public final class OffHeapVectorTransferFactory {
    public static <T> OffHeapVectorTransfer<T> getVectorTransfer(VectorDataType vectorDataType, int bytesPerVector, int totalVectorsToTransfer) {
        switch (vectorDataType) {
            case FLOAT: {
                return new OffHeapFloatVectorTransfer(bytesPerVector, totalVectorsToTransfer);
            }
            case BINARY: {
                return new OffHeapBinaryVectorTransfer(bytesPerVector, totalVectorsToTransfer);
            }
            case BYTE: {
                return new OffHeapByteVectorTransfer(bytesPerVector, totalVectorsToTransfer);
            }
        }
        throw new IllegalArgumentException("Unsupported vector data type: " + String.valueOf((Object)vectorDataType));
    }

    @Generated
    private OffHeapVectorTransferFactory() {
    }
}

