/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTransitGatewayPeeringAttachmentsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeTransitGatewayPeeringAttachmentsResponse> {
    private static final SdkField<List<TransitGatewayPeeringAttachment>> TRANSIT_GATEWAY_PEERING_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransitGatewayPeeringAttachments").getter(DescribeTransitGatewayPeeringAttachmentsResponse.getter(DescribeTransitGatewayPeeringAttachmentsResponse::transitGatewayPeeringAttachments)).setter(DescribeTransitGatewayPeeringAttachmentsResponse.setter(Builder::transitGatewayPeeringAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayPeeringAttachments").unmarshallLocationName("transitGatewayPeeringAttachments").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransitGatewayPeeringAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeTransitGatewayPeeringAttachmentsResponse.getter(DescribeTransitGatewayPeeringAttachmentsResponse::nextToken)).setter(DescribeTransitGatewayPeeringAttachmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_PEERING_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTransitGatewayPeeringAttachmentsResponse.memberNameToFieldInitializer();
    private final List<TransitGatewayPeeringAttachment> transitGatewayPeeringAttachments;
    private final String nextToken;

    private DescribeTransitGatewayPeeringAttachmentsResponse(BuilderImpl builder) {
        super(builder);
        this.transitGatewayPeeringAttachments = builder.transitGatewayPeeringAttachments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTransitGatewayPeeringAttachments() {
        return this.transitGatewayPeeringAttachments != null && !(this.transitGatewayPeeringAttachments instanceof SdkAutoConstructList);
    }

    public final List<TransitGatewayPeeringAttachment> transitGatewayPeeringAttachments() {
        return this.transitGatewayPeeringAttachments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransitGatewayPeeringAttachments() ? this.transitGatewayPeeringAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransitGatewayPeeringAttachmentsResponse)) {
            return false;
        }
        DescribeTransitGatewayPeeringAttachmentsResponse other = (DescribeTransitGatewayPeeringAttachmentsResponse)((Object)obj);
        return this.hasTransitGatewayPeeringAttachments() == other.hasTransitGatewayPeeringAttachments() && Objects.equals(this.transitGatewayPeeringAttachments(), other.transitGatewayPeeringAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTransitGatewayPeeringAttachmentsResponse").add("TransitGatewayPeeringAttachments", this.hasTransitGatewayPeeringAttachments() ? this.transitGatewayPeeringAttachments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayPeeringAttachments": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayPeeringAttachments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransitGatewayPeeringAttachments", TRANSIT_GATEWAY_PEERING_ATTACHMENTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransitGatewayPeeringAttachmentsResponse, T> g) {
        return obj -> g.apply((DescribeTransitGatewayPeeringAttachmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<TransitGatewayPeeringAttachment> transitGatewayPeeringAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransitGatewayPeeringAttachmentsResponse model) {
            super(model);
            this.transitGatewayPeeringAttachments(model.transitGatewayPeeringAttachments);
            this.nextToken(model.nextToken);
        }

        public final List<TransitGatewayPeeringAttachment.Builder> getTransitGatewayPeeringAttachments() {
            List<TransitGatewayPeeringAttachment.Builder> result = TransitGatewayPeeringAttachmentListCopier.copyToBuilder(this.transitGatewayPeeringAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitGatewayPeeringAttachments(Collection<TransitGatewayPeeringAttachment.BuilderImpl> transitGatewayPeeringAttachments) {
            this.transitGatewayPeeringAttachments = TransitGatewayPeeringAttachmentListCopier.copyFromBuilder(transitGatewayPeeringAttachments);
        }

        @Override
        public final Builder transitGatewayPeeringAttachments(Collection<TransitGatewayPeeringAttachment> transitGatewayPeeringAttachments) {
            this.transitGatewayPeeringAttachments = TransitGatewayPeeringAttachmentListCopier.copy(transitGatewayPeeringAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayPeeringAttachments(TransitGatewayPeeringAttachment ... transitGatewayPeeringAttachments) {
            this.transitGatewayPeeringAttachments(Arrays.asList(transitGatewayPeeringAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayPeeringAttachments(Consumer<TransitGatewayPeeringAttachment.Builder> ... transitGatewayPeeringAttachments) {
            this.transitGatewayPeeringAttachments(Stream.of(transitGatewayPeeringAttachments).map(c -> (TransitGatewayPeeringAttachment)((TransitGatewayPeeringAttachment.Builder)TransitGatewayPeeringAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeTransitGatewayPeeringAttachmentsResponse build() {
            return new DescribeTransitGatewayPeeringAttachmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTransitGatewayPeeringAttachmentsResponse> {
        public Builder transitGatewayPeeringAttachments(Collection<TransitGatewayPeeringAttachment> var1);

        public Builder transitGatewayPeeringAttachments(TransitGatewayPeeringAttachment ... var1);

        public Builder transitGatewayPeeringAttachments(Consumer<TransitGatewayPeeringAttachment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

