/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.EntityProfileName;

public class EntityProfileRequest
extends ActionRequest
implements ToXContentObject {
    public static final String ENTITY = "entity";
    public static final String PROFILES = "profiles";
    private String configID;
    private Entity entityValue;
    private Set<EntityProfileName> profilesToCollect;

    public EntityProfileRequest(StreamInput in) throws IOException {
        super(in);
        this.configID = in.readString();
        this.entityValue = new Entity(in);
        int size = in.readVInt();
        this.profilesToCollect = new HashSet<EntityProfileName>();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                this.profilesToCollect.add((EntityProfileName)in.readEnum(EntityProfileName.class));
            }
        }
    }

    public EntityProfileRequest(String adID, Entity entityValue, Set<EntityProfileName> profilesToCollect) {
        this.configID = adID;
        this.entityValue = entityValue;
        this.profilesToCollect = profilesToCollect;
    }

    public String getConfigID() {
        return this.configID;
    }

    public Entity getEntityValue() {
        return this.entityValue;
    }

    public Set<EntityProfileName> getProfilesToCollect() {
        return this.profilesToCollect;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.configID);
        this.entityValue.writeTo(out);
        out.writeVInt(this.profilesToCollect.size());
        for (EntityProfileName profile : this.profilesToCollect) {
            out.writeEnum((Enum)profile);
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.configID)) {
            validationException = ValidateActions.addValidationError((String)"config ID is missing", validationException);
        }
        if (this.entityValue == null) {
            validationException = ValidateActions.addValidationError((String)"Entity value is missing", (ActionRequestValidationException)validationException);
        }
        if (this.profilesToCollect == null || this.profilesToCollect.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)CommonMessages.EMPTY_PROFILES_COLLECT, (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("config_id", this.configID);
        builder.field(ENTITY, (ToXContent)this.entityValue);
        builder.field(PROFILES, this.profilesToCollect);
        builder.endObject();
        return builder;
    }
}

