/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocRequest;
import org.opensearch.action.ValidateActions;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class DeleteConfigRequest
extends ActionRequest
implements DocRequest {
    private String configID;
    private String configIndex;

    public DeleteConfigRequest(StreamInput in) throws IOException {
        super(in);
        this.configID = in.readString();
        this.configIndex = in.readString();
    }

    public DeleteConfigRequest(String configId, String configIndex) {
        this.configID = configId;
        this.configIndex = configIndex;
    }

    public String getConfigID() {
        return this.configID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.configID);
        out.writeString(this.configIndex);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.configID)) {
            validationException = ValidateActions.addValidationError((String)"config ID is missing", validationException);
        }
        return validationException;
    }

    public String type() {
        return this.configIndex.startsWith(ADIndex.CONFIG.getIndexName()) ? "anomaly-detector" : "forecaster";
    }

    public String index() {
        return this.configIndex;
    }

    public String id() {
        return this.configID;
    }
}

