/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.nio.file.Files;
import java.nio.file.Path;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.cache.RemovalReason;
import org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.opensearch.index.store.remote.filecache.FileCache;
import org.opensearch.index.store.remote.utils.cache.SegmentedCache;

public class FileCacheFactory {
    public static FileCache createConcurrentLRUFileCache(long capacity) {
        return new FileCache(FileCacheFactory.createDefaultBuilder().capacity(capacity).build());
    }

    public static FileCache createConcurrentLRUFileCache(long capacity, int concurrencyLevel) {
        return new FileCache(FileCacheFactory.createDefaultBuilder().capacity(capacity).concurrencyLevel(concurrencyLevel).build());
    }

    private static SegmentedCache.Builder<Path, CachedIndexInput> createDefaultBuilder() {
        return SegmentedCache.builder().weigher(CachedIndexInput::length).listener(removalNotification -> {
            RemovalReason removalReason = removalNotification.getRemovalReason();
            CachedIndexInput value = (CachedIndexInput)removalNotification.getValue();
            Path key = (Path)removalNotification.getKey();
            if (removalReason != RemovalReason.REPLACED) {
                ExceptionsHelper.catchAsRuntimeException(value::close);
                if (removalReason != RemovalReason.RESTARTED) {
                    ExceptionsHelper.catchAsRuntimeException(() -> Files.deleteIfExists(key));
                }
            }
        });
    }
}

