/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.AssociationOverride;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.ModelsContext;

public class AssociationOverrideJpaAnnotation
implements AssociationOverride {
    private String name;
    private JoinColumn[] joinColumns;
    private ForeignKey foreignKey;
    private JoinTable joinTable;

    public AssociationOverrideJpaAnnotation(ModelsContext modelContext) {
        this.joinColumns = new JoinColumn[0];
        this.foreignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
        this.joinTable = (JoinTable)JpaAnnotations.JOIN_TABLE.createUsage(modelContext);
    }

    public AssociationOverrideJpaAnnotation(AssociationOverride annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.joinColumns = (JoinColumn[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "joinColumns", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "foreignKey", modelContext);
        this.joinTable = (JoinTable)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.ASSOCIATION_OVERRIDE, "joinTable", modelContext);
    }

    public AssociationOverrideJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.joinColumns = (JoinColumn[])attributeValues.get("joinColumns");
        this.foreignKey = (ForeignKey)attributeValues.get("foreignKey");
        this.joinTable = (JoinTable)attributeValues.get("joinTable");
    }

    public Class<? extends Annotation> annotationType() {
        return AssociationOverride.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public JoinColumn[] joinColumns() {
        return this.joinColumns;
    }

    public void joinColumns(JoinColumn[] value) {
        this.joinColumns = value;
    }

    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }

    public JoinTable joinTable() {
        return this.joinTable;
    }

    public void joinTable(JoinTable value) {
        this.joinTable = value;
    }
}

