/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.io.InvalidObjectException;
import java.security.Permission;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;
import org.wildfly.security.permission.InvalidPermissionClassException;
import org.wildfly.security.permission.PermissionVerifier;

@MessageLogger(projectCode="ELY", length=5)
@ValidIdRanges(value={@ValidIdRange(min=3013, max=3022)})
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");

    @Message(id=3013, value="Permission collection must be read-only")
    public SecurityException permissionCollectionMustBeReadOnly();

    @Message(id=3015, value="Could not load permission class \"%s\"")
    public InvalidPermissionClassException permissionClassMissing(String var1, @Cause ClassNotFoundException var2);

    @Message(id=3016, value="Could not instantiate permission class \"%s\"")
    public InvalidPermissionClassException permissionInstantiation(String var1, @Cause Throwable var2);

    @Message(id=3017, value="No valid permission constructor found on class \"%s\"")
    public InvalidPermissionClassException noPermissionConstructor(String var1);

    @Message(id=3018, value="Cannot add permissions to a read-only permission collection")
    public SecurityException readOnlyPermissionCollection();

    @Message(id=3019, value="Failure to deserialize object: field \"%s\" is null")
    public InvalidObjectException invalidObjectNull(String var1);

    @Message(id=3020, value="Expected empty actions string, got \"%s\"")
    public IllegalArgumentException expectedEmptyActions(String var1);

    @Message(id=3021, value="Invalid permission type; expected %s, got %s")
    public IllegalArgumentException invalidPermissionType(Class<? extends Permission> var1, Permission var2);

    @Message(id=3022, value="Permission check failed: %s is not implied by %s")
    public SecurityException permissionCheckFailed(Permission var1, PermissionVerifier var2);
}

