/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.collection.spi.AbstractSetSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentSortedSet;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.persister.collection.CollectionPersister;

public class StandardSortedSetSemantics<E>
extends AbstractSetSemantics<SortedSet<E>, E> {
    public static final StandardSortedSetSemantics<?> INSTANCE = new StandardSortedSetSemantics();

    private StandardSortedSetSemantics() {
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.SORTED_SET;
    }

    @Override
    public Class<SortedSet> getCollectionJavaType() {
        return SortedSet.class;
    }

    @Override
    public SortedSet<E> instantiateRaw(int anticipatedSize, CollectionPersister collectionDescriptor) {
        return new TreeSet(collectionDescriptor == null ? null : collectionDescriptor.getSortingComparator());
    }

    @Override
    public PersistentCollection<E> instantiateWrapper(Object key, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentSortedSet(session, collectionDescriptor.getSortingComparator());
    }

    @Override
    public PersistentCollection<E> wrap(SortedSet<E> rawCollection, CollectionPersister collectionDescriptor, SharedSessionContractImplementor session) {
        return new PersistentSortedSet<E>(session, rawCollection);
    }

    @Override
    public Iterator<E> getElementIterator(SortedSet<E> rawCollection) {
        return rawCollection.iterator();
    }
}

