/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToManyImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.ManyToManyJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.TargetXmlAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonPluralAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class ManyToManyAttributeProcessing {
    public static MutableMemberDetails processManyToManyAttribute(JaxbManyToManyImpl jaxbManyToMany, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbManyToMany.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbManyToMany.getName(), accessType, declarer);
        ManyToManyJpaAnnotation manyToManyAnn = ManyToManyAttributeProcessing.applyManyToMany(jaxbManyToMany, memberDetails, xmlDocumentContext);
        ManyToManyAttributeProcessing.applyTarget(jaxbManyToMany, xmlDocumentContext, memberDetails);
        XmlAnnotationHelper.applyCascading(jaxbManyToMany.getCascade(), memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbManyToMany, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyFetching(jaxbManyToMany, memberDetails, manyToManyAnn, xmlDocumentContext);
        CommonPluralAttributeProcessing.applyPluralAttributeStructure(jaxbManyToMany, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbManyToMany.getMapKeyAttributeOverrides(), (MutableAnnotationTarget)memberDetails, "key", xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbManyToMany.getJoinTable(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlJoinTableRestriction(jaxbManyToMany.getSqlJoinTableRestriction(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyJoinTableFilters(jaxbManyToMany.getJoinTableFilters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyNotFound(jaxbManyToMany, memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    private static void applyTarget(JaxbManyToManyImpl jaxbManyToMany, XmlDocumentContext xmlDocumentContext, MutableMemberDetails memberDetails) {
        if (StringHelper.isEmpty(jaxbManyToMany.getTargetEntity())) {
            return;
        }
        TargetXmlAnnotation targetAnn = (TargetXmlAnnotation)memberDetails.applyAnnotationUsage(XmlAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
        targetAnn.value(xmlDocumentContext.resolveClassName(jaxbManyToMany.getTargetEntity()));
    }

    private static ManyToManyJpaAnnotation applyManyToMany(JaxbManyToManyImpl jaxbManyToMany, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ManyToManyJpaAnnotation manyToManyAnn = (ManyToManyJpaAnnotation)memberDetails.applyAnnotationUsage(JpaAnnotations.MANY_TO_MANY, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyFetching(jaxbManyToMany, memberDetails, manyToManyAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyMappedBy(jaxbManyToMany.getMappedBy(), manyToManyAnn, xmlDocumentContext);
        return manyToManyAnn;
    }
}

