/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedLength;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMEllipseElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;

public class SVGEllipseElementBridge
extends SVGShapeElementBridge {
    @Override
    public String getLocalName() {
        return "ellipse";
    }

    @Override
    public Bridge getInstance() {
        return new SVGEllipseElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext ctx, Element e, ShapeNode shapeNode) throws BridgeException {
        float ry;
        float rx;
        SVGOMEllipseElement ee = (SVGOMEllipseElement)e;
        AbstractSVGAnimatedLength _cx = (AbstractSVGAnimatedLength)ee.getCx();
        float cx = this.safeAnimatedLength(_cx, 0.0f);
        AbstractSVGAnimatedLength _cy = (AbstractSVGAnimatedLength)ee.getCy();
        float cy = this.safeAnimatedLength(_cy, 0.0f);
        boolean rxAuto = false;
        AbstractSVGAnimatedLength _rx = (AbstractSVGAnimatedLength)ee.getRx();
        try {
            rx = _rx.getCheckedValue();
        }
        catch (LiveAttributeException ex) {
            rx = 0.0f;
            rxAuto = true;
            SVGEllipseElementBridge.reportLiveAttributeException(ctx, ex);
        }
        AbstractSVGAnimatedLength _ry = (AbstractSVGAnimatedLength)ee.getRy();
        try {
            ry = _ry.getCheckedValue();
        }
        catch (LiveAttributeException ex) {
            ry = rx;
            SVGEllipseElementBridge.reportLiveAttributeException(ctx, ex);
        }
        if (rxAuto) {
            rx = ry;
        }
        try {
            shapeNode.setShape((Shape)new Ellipse2D.Float(cx - rx, cy - ry, rx * 2.0f, ry * 2.0f));
        }
        catch (LiveAttributeException ex) {
            throw new BridgeException(ctx, ex);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue alav) {
        String ln;
        if (alav.getNamespaceURI() == null && ((ln = alav.getLocalName()).equals("cx") || ln.equals("cy") || ln.equals("rx") || ln.equals("ry"))) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(alav);
    }

    @Override
    protected ShapePainter createShapePainter(BridgeContext ctx, Element e, ShapeNode shapeNode) {
        Rectangle2D r2d = shapeNode.getShape().getBounds2D();
        if (r2d.getWidth() == 0.0 || r2d.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(ctx, e, shapeNode);
    }
}

