/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.echosvg.anim.dom.BindableElement;
import io.sf.carte.echosvg.anim.dom.SVG12OMDocument;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGOMFlowDivElement;
import io.sf.carte.echosvg.anim.dom.SVGOMFlowLineElement;
import io.sf.carte.echosvg.anim.dom.SVGOMFlowParaElement;
import io.sf.carte.echosvg.anim.dom.SVGOMFlowRegionBreakElement;
import io.sf.carte.echosvg.anim.dom.SVGOMFlowRegionElement;
import io.sf.carte.echosvg.anim.dom.SVGOMFlowRegionExcludeElement;
import io.sf.carte.echosvg.anim.dom.SVGOMFlowRootElement;
import io.sf.carte.echosvg.anim.dom.SVGOMFlowSpanElement;
import io.sf.carte.echosvg.anim.dom.SVGOMHandlerElement;
import io.sf.carte.echosvg.anim.dom.SVGOMMultiImageElement;
import io.sf.carte.echosvg.anim.dom.SVGOMSolidColorElement;
import io.sf.carte.echosvg.anim.dom.SVGOMSubImageElement;
import io.sf.carte.echosvg.anim.dom.SVGOMSubImageRefElement;
import io.sf.carte.echosvg.anim.dom.XBLEventSupport;
import io.sf.carte.echosvg.anim.dom.XBLOMContentElement;
import io.sf.carte.echosvg.anim.dom.XBLOMDefinitionElement;
import io.sf.carte.echosvg.anim.dom.XBLOMHandlerGroupElement;
import io.sf.carte.echosvg.anim.dom.XBLOMImportElement;
import io.sf.carte.echosvg.anim.dom.XBLOMShadowTreeElement;
import io.sf.carte.echosvg.anim.dom.XBLOMTemplateElement;
import io.sf.carte.echosvg.anim.dom.XBLOMXBLElement;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.SVG12CSSEngine;
import io.sf.carte.echosvg.css.engine.value.ShorthandManager;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractNode;
import io.sf.carte.echosvg.dom.AbstractStylableDocument;
import io.sf.carte.echosvg.dom.ExtensibleDOMImplementation;
import io.sf.carte.echosvg.dom.GenericElement;
import io.sf.carte.echosvg.dom.events.DocumentEventSupport;
import io.sf.carte.echosvg.dom.events.EventSupport;
import io.sf.carte.echosvg.dom.svg12.SVGOMWheelEvent;
import io.sf.carte.echosvg.dom.svg12.XBLOMShadowTreeEvent;
import io.sf.carte.echosvg.dom.util.DOMUtilities;
import io.sf.carte.echosvg.util.ParsedURL;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;

public class SVG12DOMImplementation
extends SVGDOMImplementation {
    private static final long serialVersionUID = 1L;
    protected static HashMap<String, ExtensibleDOMImplementation.ElementFactory> svg12Factories = new HashMap(svgFactories);
    protected static HashMap<String, ExtensibleDOMImplementation.ElementFactory> xblFactories;
    protected static final DOMImplementation DOM_IMPLEMENTATION;

    public SVG12DOMImplementation() {
        this.factories = svg12Factories;
        this.registerFeature("CSS", "2.0");
        this.registerFeature("StyleSheets", "2.0");
        this.registerFeature("SVG", new String[]{"1.0", "1.1", "1.2"});
        this.registerFeature("SVGEvents", new String[]{"1.0", "1.1", "1.2"});
    }

    @Override
    CSSEngine createCSSEngine(AbstractStylableDocument doc, ParsedURL durl, Parser p, ValueManager[] vms, ShorthandManager[] sms, CSSContext ctx) {
        return new SVG12CSSEngine((Document)doc, durl, p, vms, sms, ctx);
    }

    @Override
    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        SVG12OMDocument result = new SVG12OMDocument(doctype, (DOMImplementation)((Object)this));
        result.setIsSVG12(true);
        if (qualifiedName != null) {
            result.appendChild(result.createElementNS(namespaceURI, qualifiedName));
        }
        return result;
    }

    @Override
    public Element createElementNS(AbstractDocument document, String namespaceURI, String qualifiedName) {
        ExtensibleDOMImplementation.ElementFactory cef;
        ExtensibleDOMImplementation.ElementFactory ef;
        if (namespaceURI == null) {
            return new GenericElement(qualifiedName.intern(), document);
        }
        String name = DOMUtilities.getLocalName((String)qualifiedName);
        String prefix = DOMUtilities.getPrefix((String)qualifiedName);
        if ("http://www.w3.org/2000/svg".equals(namespaceURI) ? (ef = (ExtensibleDOMImplementation.ElementFactory)this.factories.get(name)) != null : "http://www.w3.org/2004/xbl".equals(namespaceURI) && (ef = xblFactories.get(name)) != null) {
            return ef.create(prefix, (Document)document);
        }
        if (this.customFactories != null && (cef = (ExtensibleDOMImplementation.ElementFactory)this.customFactories.get((Object)namespaceURI, (Object)name)) != null) {
            return cef.create(prefix, (Document)document);
        }
        return new BindableElement(prefix, document, namespaceURI, name);
    }

    @Override
    public DocumentEventSupport createDocumentEventSupport() {
        DocumentEventSupport result = super.createDocumentEventSupport();
        result.registerEventFactory("WheelEvent", new DocumentEventSupport.EventFactory(){

            public Event createEvent() {
                return new SVGOMWheelEvent();
            }
        });
        result.registerEventFactory("ShadowTreeEvent", new DocumentEventSupport.EventFactory(){

            public Event createEvent() {
                return new XBLOMShadowTreeEvent();
            }
        });
        return result;
    }

    public EventSupport createEventSupport(AbstractNode n) {
        return new XBLEventSupport(n);
    }

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    static {
        svg12Factories.put("flowDiv", new FlowDivElementFactory());
        svg12Factories.put("flowLine", new FlowLineElementFactory());
        svg12Factories.put("flowPara", new FlowParaElementFactory());
        svg12Factories.put("flowRegionBreak", new FlowRegionBreakElementFactory());
        svg12Factories.put("flowRegion", new FlowRegionElementFactory());
        svg12Factories.put("flowRegionExclude", new FlowRegionExcludeElementFactory());
        svg12Factories.put("flowRoot", new FlowRootElementFactory());
        svg12Factories.put("flowSpan", new FlowSpanElementFactory());
        svg12Factories.put("handler", new HandlerElementFactory());
        svg12Factories.put("multiImage", new MultiImageElementFactory());
        svg12Factories.put("solidColor", new SolidColorElementFactory());
        svg12Factories.put("subImage", new SubImageElementFactory());
        svg12Factories.put("subImageRef", new SubImageRefElementFactory());
        xblFactories = new HashMap();
        xblFactories.put("xbl", new XBLXBLElementFactory());
        xblFactories.put("definition", new XBLDefinitionElementFactory());
        xblFactories.put("template", new XBLTemplateElementFactory());
        xblFactories.put("content", new XBLContentElementFactory());
        xblFactories.put("handlerGroup", new XBLHandlerGroupElementFactory());
        xblFactories.put("import", new XBLImportElementFactory());
        xblFactories.put("shadowTree", new XBLShadowTreeElementFactory());
        DOM_IMPLEMENTATION = new SVG12DOMImplementation();
    }

    protected static class FlowDivElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowDivElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowLineElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowLineElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowParaElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowParaElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRegionBreakElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowRegionBreakElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRegionElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowRegionElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRegionExcludeElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowRegionExcludeElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowRootElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowRootElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class FlowSpanElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMFlowSpanElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class HandlerElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMHandlerElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class MultiImageElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMMultiImageElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SolidColorElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSolidColorElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SubImageElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSubImageElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class SubImageRefElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new SVGOMSubImageRefElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class XBLXBLElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new XBLOMXBLElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class XBLDefinitionElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new XBLOMDefinitionElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class XBLTemplateElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new XBLOMTemplateElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class XBLContentElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new XBLOMContentElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class XBLHandlerGroupElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new XBLOMHandlerGroupElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class XBLImportElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new XBLOMImportElement(prefix, (AbstractDocument)doc);
        }
    }

    protected static class XBLShadowTreeElementFactory
    implements ExtensibleDOMImplementation.ElementFactory {
        public Element create(String prefix, Document doc) {
            return new XBLOMShadowTreeElement(prefix, (AbstractDocument)doc);
        }
    }
}

