/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.PropertiesDictionary;
import org.knopflerfish.framework.ServiceListenerEntry;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.dto.ServiceReferenceDTO;

public class ServiceRegistrationImpl<S>
implements ServiceRegistration<S> {
    final FrameworkContext fwCtx;
    BundleImpl bundle;
    Object service;
    final String scope;
    ServiceReferenceImpl<S> reference;
    private PropertiesDictionary properties;
    private Hashtable<Bundle, Integer> dependents = new Hashtable();
    private HashMap<Bundle, S> serviceInstances = null;
    private HashMap<Bundle, List<S>> prototypeServiceInstances = null;
    private final HashSet<Bundle> ungetInProgress = new HashSet();
    private volatile boolean available;
    private final Object eventLock = new Object();
    private volatile boolean unregistering = false;
    private Thread factoryThread = null;

    ServiceRegistrationImpl(BundleImpl b, Object s, String ss, PropertiesDictionary props) {
        this.fwCtx = b.fwCtx;
        this.bundle = b;
        this.service = s;
        this.properties = props;
        this.reference = new ServiceReferenceImpl(this);
        this.available = true;
        this.scope = ss;
        if (this.scope == "bundle") {
            this.serviceInstances = new HashMap();
        } else if (this.scope == "prototype") {
            this.serviceInstances = new HashMap();
            this.prototypeServiceInstances = new HashMap();
        }
    }

    @Override
    public ServiceReference<S> getReference() {
        ServiceReferenceImpl<S> res = this.reference;
        if (res != null) {
            return res;
        }
        throw new IllegalStateException("Service is unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Dictionary<String, ?> props) {
        Object object = this.eventLock;
        synchronized (object) {
            if (this.available) {
                Set<ServiceListenerEntry> before;
                Services services = this.fwCtx.services;
                synchronized (services) {
                    PropertiesDictionary propertiesDictionary = this.properties;
                    synchronized (propertiesDictionary) {
                        Object old_rank = this.properties.get("service.ranking");
                        before = this.fwCtx.listeners.getMatchingServiceListeners(this.reference);
                        String[] classes = (String[])this.properties.get("objectClass");
                        Long sid = (Long)this.properties.get("service.id");
                        this.properties = new PropertiesDictionary(props, classes, sid, new Long(this.bundle.id), this.scope);
                        Object new_rank = this.properties.get("service.ranking");
                        if (old_rank != new_rank && new_rank instanceof Integer && !((Integer)new_rank).equals(old_rank)) {
                            this.fwCtx.services.updateServiceRegistrationOrder(this, classes);
                        }
                    }
                }
                this.fwCtx.perm.callServiceChanged(this.fwCtx, this.fwCtx.listeners.getMatchingServiceListeners(this.reference), new ServiceEvent(2, this.reference), before);
                if (!before.isEmpty()) {
                    this.fwCtx.perm.callServiceChanged(this.fwCtx, before, new ServiceEvent(8, this.reference), null);
                }
            } else {
                throw new IllegalStateException("Service is unregistered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        if (this.unregistering) {
            return;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (this.unregistering) {
                return;
            }
            this.unregistering = true;
            if (this.available) {
                if (null != this.bundle) {
                    this.fwCtx.services.removeServiceRegistration(this);
                }
            } else {
                throw new IllegalStateException("Service is unregistered");
            }
        }
        if (null != this.bundle) {
            this.fwCtx.perm.callServiceChanged(this.fwCtx, this.fwCtx.listeners.getMatchingServiceListeners(this.reference), new ServiceEvent(4, this.reference), null);
        }
        object = this.eventLock;
        synchronized (object) {
            this.available = false;
            Bundle[] using = this.getUsingBundles();
            if (using != null) {
                for (Bundle element : using) {
                    this.ungetService(element, false, null);
                }
            }
            PropertiesDictionary propertiesDictionary = this.properties;
            synchronized (propertiesDictionary) {
                this.bundle = null;
                this.dependents = null;
                this.reference = null;
                this.service = null;
                this.serviceInstances = null;
                this.prototypeServiceInstances = null;
                this.unregistering = false;
            }
        }
    }

    boolean isAvailable() {
        return this.available;
    }

    PropertiesDictionary getProperties() {
        return this.properties;
    }

    Object getProperty(String key) {
        return this.properties.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    S getService(Bundle b, boolean multiple) {
        Integer ref;
        BundleImpl sBundle = null;
        if (multiple && this.scope != "prototype") {
            multiple = false;
        }
        PropertiesDictionary propertiesDictionary = this.properties;
        synchronized (propertiesDictionary) {
            if (this.available) {
                ref = this.dependents.get(b);
                if (this.scope == "singleton") {
                    this.dependents.put(b, new Integer(ref != null ? ref + 1 : 1));
                    Object res = this.service;
                    return (S)res;
                }
                if (!multiple) {
                    if (ref == null) {
                        this.dependents.put(b, new Integer(0));
                        this.factoryThread = Thread.currentThread();
                    } else if (this.factoryThread != null && this.factoryThread.equals(Thread.currentThread())) {
                        throw new IllegalStateException("Recursive call of getService");
                    }
                }
            } else {
                return null;
            }
            sBundle = this.bundle;
        }
        Object s = null;
        if (ref == null || multiple) {
            Object classes;
            try {
                s = sBundle.fwCtx.perm.callGetService(this, b);
                if (s == null) {
                    sBundle.fwCtx.frameworkWarning(sBundle, (Throwable)new ServiceException("ServiceFactory produced null", 2), new FrameworkListener[0]);
                }
            }
            catch (Throwable pe) {
                sBundle.fwCtx.frameworkError(sBundle, (Throwable)new ServiceException("ServiceFactory throw an exception", 3, pe), new FrameworkListener[0]);
            }
            if (s != null) {
                for (String cls : classes = (String[])this.getProperty("objectClass")) {
                    if (sBundle.fwCtx.services.checkServiceClass(s, cls)) continue;
                    sBundle.fwCtx.frameworkError(sBundle, (Throwable)new ServiceException("ServiceFactory produced an object that did not implement: " + cls, 2), new FrameworkListener[0]);
                    s = null;
                    break;
                }
            }
            if (s == null) {
                if (!multiple) {
                    classes = this.properties;
                    synchronized (classes) {
                        if (this.dependents != null && ref == null) {
                            this.dependents.remove(b);
                        }
                        this.factoryThread = null;
                    }
                }
                return null;
            }
        }
        boolean recall = false;
        String[] arr$ = this.properties;
        synchronized (this.properties) {
            if (s == null) {
                while ((s = this.serviceInstances.get(b)) == null) {
                    try {
                        this.properties.wait(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (this.dependents != null && this.dependents.containsKey(b)) continue;
                    break;
                }
            } else if (multiple) {
                List<S> il = this.prototypeServiceInstances.get(b);
                if (il == null) {
                    il = new LinkedList<S>();
                    this.prototypeServiceInstances.put(b, il);
                }
                il.add(s);
            } else {
                this.factoryThread = null;
                this.serviceInstances.put(b, s);
                this.properties.notifyAll();
            }
            if (s != null && !multiple) {
                Integer n = ref = this.dependents != null ? this.dependents.get(b) : null;
                if (ref != null) {
                    this.dependents.put(b, new Integer(ref + 1));
                } else {
                    recall = true;
                }
            }
            // ** MonitorExit[arr$] (shouldn't be in output)
            if (recall) {
                try {
                    sBundle.fwCtx.perm.callUngetService(this, b, s);
                }
                catch (Throwable e) {
                    sBundle.fwCtx.frameworkError(sBundle, e, new FrameworkListener[0]);
                }
                return null;
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bundle[] getUsingBundles() {
        Hashtable<Bundle, Integer> d = this.dependents;
        if (d != null) {
            Hashtable<Bundle, Integer> hashtable = d;
            synchronized (hashtable) {
                HashSet<Bundle> bs = new HashSet<Bundle>();
                bs.addAll(d.keySet());
                bs.addAll(this.ungetInProgress);
                if (this.prototypeServiceInstances != null) {
                    bs.addAll(this.prototypeServiceInstances.keySet());
                }
                if (!bs.isEmpty()) {
                    return bs.toArray(new Bundle[bs.size()]);
                }
            }
        }
        return null;
    }

    boolean isUsedByBundle(Bundle b) {
        Hashtable<Bundle, Integer> deps = this.dependents;
        if (deps != null) {
            boolean res = deps.containsKey(b);
            if (!res && this.prototypeServiceInstances != null) {
                res = this.prototypeServiceInstances.containsKey(b);
            }
            return res;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ungetService(Bundle b, boolean checkRefCounter, S uservice) {
        BundleImpl sBundle;
        ArrayList<S> servicesToRemove = new ArrayList<S>();
        Hashtable<Bundle, Integer> deps = null;
        boolean res = false;
        PropertiesDictionary propertiesDictionary = this.properties;
        synchronized (propertiesDictionary) {
            Integer countInteger;
            if (this.dependents == null) {
                return false;
            }
            if (this.scope == "prototype") {
                List<S> sl;
                if (uservice != null) {
                    sl = this.prototypeServiceInstances.get(b);
                    if (sl != null) {
                        Iterator<S> i = sl.iterator();
                        while (i.hasNext()) {
                            if (i.next() != uservice) continue;
                            i.remove();
                            servicesToRemove.add(uservice);
                            res = true;
                            break;
                        }
                    }
                    if (!res) {
                        throw new IllegalArgumentException("Service is not in use or not from this service reference");
                    }
                } else if (!checkRefCounter && (sl = this.prototypeServiceInstances.get(b)) != null && !sl.isEmpty()) {
                    servicesToRemove.addAll(sl);
                    sl.clear();
                    res = true;
                }
            }
            if ((uservice == null || this.scope != "prototype") && (countInteger = this.dependents.get(b)) != null) {
                if (uservice != null) {
                    Object s;
                    Object object = s = this.scope == "singleton" ? this.service : this.serviceInstances.get(b);
                    if (s != uservice) {
                        throw new IllegalArgumentException("Service is not in user or not from this service reference");
                    }
                }
                int count = countInteger;
                if (checkRefCounter && count > 1) {
                    this.dependents.put(b, new Integer(count - 1));
                } else {
                    S s;
                    Hashtable<Bundle, Integer> hashtable = this.dependents;
                    synchronized (hashtable) {
                        this.ungetInProgress.add(b);
                        this.dependents.remove(b);
                        deps = this.dependents;
                    }
                    if (this.scope != "singleton" && (s = this.serviceInstances.remove(b)) != null) {
                        servicesToRemove.add(s);
                    }
                }
                res = true;
            }
            sBundle = this.bundle;
        }
        for (Object s : servicesToRemove) {
            try {
                sBundle.fwCtx.perm.callUngetService(this, b, s);
            }
            catch (Throwable e) {
                sBundle.fwCtx.frameworkError(sBundle, e, new FrameworkListener[0]);
            }
        }
        if (deps != null) {
            propertiesDictionary = deps;
            synchronized (propertiesDictionary) {
                this.ungetInProgress.remove(b);
            }
        }
        return res;
    }

    ServiceReferenceDTO getDTO() {
        BundleImpl b;
        ServiceReferenceDTO res = new ServiceReferenceDTO();
        PropertiesDictionary p = this.properties;
        res.id = (Long)p.get("service.id");
        res.properties = p.getDTO();
        Bundle[] using = this.getUsingBundles();
        if (using != null) {
            res.usingBundles = new long[using.length];
            for (int i = 0; i < using.length; ++i) {
                res.usingBundles[i] = using[i].getBundleId();
            }
        } else {
            res.usingBundles = new long[0];
        }
        if ((b = this.bundle) == null) {
            return null;
        }
        res.bundle = b.id;
        return res;
    }
}

