/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.xml.XMLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    @NotNull
    public static Document parseDocument(@NotNull String fileName) throws XMLException {
        return XMLUtils.parseDocument(new File(fileName));
    }

    @NotNull
    public static Document parseDocument(@NotNull File file) throws XMLException {
        Document document;
        FileInputStream is = new FileInputStream(file);
        try {
            document = XMLUtils.parseDocument(new InputSource(is));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new XMLException("Error opening file '" + String.valueOf(file) + "'", e);
            }
        }
        ((InputStream)is).close();
        return document;
    }

    @NotNull
    public static Document parseDocument(@NotNull Path file) throws XMLException {
        Document document;
        block8: {
            InputStream is = Files.newInputStream(file, new OpenOption[0]);
            try {
                document = XMLUtils.parseDocument(new InputSource(is));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new XMLException("Error opening file '" + String.valueOf(file) + "'", e);
                }
            }
            is.close();
        }
        return document;
    }

    @NotNull
    public static Document parseDocument(@NotNull InputStream is) throws XMLException {
        return XMLUtils.parseDocument(new InputSource(is));
    }

    @NotNull
    public static Document parseDocument(@NotNull Reader is) throws XMLException {
        return XMLUtils.parseDocument(new InputSource(is));
    }

    @NotNull
    public static Document parseDocument(@NotNull InputSource source) throws XMLException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder xmlBuilder = dbf.newDocumentBuilder();
            return xmlBuilder.parse(source);
        }
        catch (Exception er) {
            throw new XMLException("Error parsing XML document", er);
        }
    }

    @NotNull
    public static Document createDocument() throws XMLException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder xmlBuilder = dbf.newDocumentBuilder();
            return xmlBuilder.newDocument();
        }
        catch (Exception er) {
            throw new XMLException("Error creating XML document", er);
        }
    }

    @Nullable
    public static Element getChildElement(@Nullable Element element, @NotNull String childName) {
        if (element == null) {
            return null;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(childName)) continue;
            return (Element)node;
        }
        return null;
    }

    @Nullable
    public static String getChildElementBody(@Nullable Element element, @NotNull String childName) {
        if (element == null) {
            return null;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals(childName)) continue;
            return XMLUtils.getElementBody((Element)node);
        }
        return null;
    }

    @Nullable
    public static String getElementBody(@NotNull Element element) {
        return element.getTextContent();
    }

    @NotNull
    public static List<Element> getChildElementList(Element parent, String nodeName) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (parent != null) {
            for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !nodeName.equals(node.getNodeName())) continue;
                list.add((Element)node);
            }
        }
        return list;
    }

    @NotNull
    public static Collection<Element> getChildElementListNS(Element parent, String nsURI) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (parent != null) {
            for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !node.getNamespaceURI().equals(nsURI)) continue;
                list.add((Element)node);
            }
        }
        return list;
    }

    @NotNull
    public static Collection<Element> getChildElementListNS(Element parent, String nodeName, String nsURI) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !node.getLocalName().equals(nodeName) || !node.getNamespaceURI().equals(nsURI)) continue;
            list.add((Element)node);
        }
        return list;
    }

    @NotNull
    public static Collection<Element> getChildElementList(@NotNull Element parent, @NotNull String[] nodeNameList) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            for (String s : nodeNameList) {
                if (!node.getNodeName().equals(s)) continue;
                list.add((Element)node);
            }
        }
        return list;
    }

    @Nullable
    public static Element findChildElement(@NotNull Element parent) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Nullable
    public static Object escapeXml(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof CharSequence) {
            return XMLUtils.escapeXml((CharSequence)obj);
        }
        return obj;
    }

    @Nullable
    public static String escapeXml(@Nullable CharSequence str) {
        if (str == null) {
            return null;
        }
        StringBuilder res = null;
        int strLength = str.length();
        for (int i = 0; i < strLength; ++i) {
            char c = str.charAt(i);
            String repl = XMLUtils.encodeXMLChar(c);
            if (repl == null) {
                if (res == null) continue;
                res.append(c);
                continue;
            }
            if (res == null) {
                res = new StringBuilder(str.length() + 5);
                for (int k = 0; k < i; ++k) {
                    res.append(str.charAt(k));
                }
            }
            res.append(repl);
        }
        return res == null ? str.toString() : res.toString();
    }

    public static boolean isValidXMLChar(char c) {
        return c >= ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    @Nullable
    public static String encodeXMLChar(char ch) {
        switch (ch) {
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&#39;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
        }
        return null;
    }

    @NotNull
    public static XMLException adaptSAXException(@NotNull Exception toCatch) {
        if (toCatch instanceof XMLException) {
            return (XMLException)toCatch;
        }
        if (toCatch instanceof SAXException) {
            String message = toCatch.getMessage();
            Exception embedded = ((SAXException)toCatch).getException();
            if (embedded != null && embedded.getMessage() != null && embedded.getMessage().equals(message)) {
                return XMLUtils.adaptSAXException(embedded);
            }
            return new XMLException(message, embedded != null ? XMLUtils.adaptSAXException(embedded) : null);
        }
        return new XMLException(toCatch.getMessage(), toCatch);
    }

    @NotNull
    public static Collection<Element> getChildElementList(@Nullable Element element) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (element != null) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                children.add((Element)node);
            }
        }
        return children;
    }
}

