/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.contexts.NestableContextService;
import org.eclipse.ui.internal.contexts.SlaveContextService;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;

public class ContextServiceFactory
extends AbstractServiceFactory {
    @Override
    public Object create(Class serviceInterface, IServiceLocator parentLocator, IServiceLocator locator) {
        Expression exp;
        if (!IContextService.class.equals((Object)serviceInterface)) {
            return null;
        }
        IWorkbenchLocationService wls = locator.getService(IWorkbenchLocationService.class);
        IWorkbench wb = wls.getWorkbench();
        if (wb == null) {
            return null;
        }
        Object parent = parentLocator.getService(serviceInterface);
        if (parent == null) {
            return null;
        }
        IWorkbenchWindow window = wls.getWorkbenchWindow();
        IWorkbenchPartSite site = wls.getPartSite();
        if (site == null) {
            WorkbenchWindowExpression exp2 = new WorkbenchWindowExpression(window);
            return new SlaveContextService((IContextService)parent, exp2);
        }
        if (parent instanceof SlaveContextService && (exp = ((SlaveContextService)parent).fDefaultExpression) instanceof ActivePartExpression) {
            return new NestableContextService((IContextService)parent, exp);
        }
        exp = new ActivePartExpression(site.getPart());
        return new SlaveContextService((IContextService)parent, exp);
    }
}

