/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.editors;

import java.util.Locale;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.BaseValueEditor;

public class BooleanInlineEditor
extends BaseValueEditor<Combo> {
    public BooleanInlineEditor(IValueController controller) {
        super(controller);
    }

    @Override
    protected Combo createControl(Composite editPlaceholder) {
        Combo editor = new Combo(editPlaceholder, 8);
        editor.add("FALSE");
        editor.add("TRUE");
        editor.setEnabled(!this.valueController.isReadOnly());
        return editor;
    }

    @Override
    public Object extractEditorValue() {
        switch (((Combo)this.control).getSelectionIndex()) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    @Override
    public void primeEditorValue(@Nullable Object value) throws DBException {
        ((Combo)this.control).setText(value == null ? "FALSE" : value.toString().toUpperCase(Locale.ENGLISH));
    }
}

