﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoT {
namespace Model {

/**
 */
class GetEffectivePoliciesRequest : public IoTRequest {
 public:
  AWS_IOT_API GetEffectivePoliciesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetEffectivePolicies"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  AWS_IOT_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The principal. Valid principals are CertificateArn
   * (arn:aws:iot:<i>region</i>:<i>accountId</i>:cert/<i>certificateId</i>),
   * thingGroupArn
   * (arn:aws:iot:<i>region</i>:<i>accountId</i>:thinggroup/<i>groupName</i>) and
   * CognitoId (<i>region</i>:<i>id</i>).</p>
   */
  inline const Aws::String& GetPrincipal() const { return m_principal; }
  inline bool PrincipalHasBeenSet() const { return m_principalHasBeenSet; }
  template <typename PrincipalT = Aws::String>
  void SetPrincipal(PrincipalT&& value) {
    m_principalHasBeenSet = true;
    m_principal = std::forward<PrincipalT>(value);
  }
  template <typename PrincipalT = Aws::String>
  GetEffectivePoliciesRequest& WithPrincipal(PrincipalT&& value) {
    SetPrincipal(std::forward<PrincipalT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Cognito identity pool ID.</p>
   */
  inline const Aws::String& GetCognitoIdentityPoolId() const { return m_cognitoIdentityPoolId; }
  inline bool CognitoIdentityPoolIdHasBeenSet() const { return m_cognitoIdentityPoolIdHasBeenSet; }
  template <typename CognitoIdentityPoolIdT = Aws::String>
  void SetCognitoIdentityPoolId(CognitoIdentityPoolIdT&& value) {
    m_cognitoIdentityPoolIdHasBeenSet = true;
    m_cognitoIdentityPoolId = std::forward<CognitoIdentityPoolIdT>(value);
  }
  template <typename CognitoIdentityPoolIdT = Aws::String>
  GetEffectivePoliciesRequest& WithCognitoIdentityPoolId(CognitoIdentityPoolIdT&& value) {
    SetCognitoIdentityPoolId(std::forward<CognitoIdentityPoolIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The thing name.</p>
   */
  inline const Aws::String& GetThingName() const { return m_thingName; }
  inline bool ThingNameHasBeenSet() const { return m_thingNameHasBeenSet; }
  template <typename ThingNameT = Aws::String>
  void SetThingName(ThingNameT&& value) {
    m_thingNameHasBeenSet = true;
    m_thingName = std::forward<ThingNameT>(value);
  }
  template <typename ThingNameT = Aws::String>
  GetEffectivePoliciesRequest& WithThingName(ThingNameT&& value) {
    SetThingName(std::forward<ThingNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_principal;

  Aws::String m_cognitoIdentityPoolId;

  Aws::String m_thingName;
  bool m_principalHasBeenSet = false;
  bool m_cognitoIdentityPoolIdHasBeenSet = false;
  bool m_thingNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
