/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.ignore;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.ignore.HgIgnoredFileContentProviderKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J#\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0016*\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J8\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001e\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\tH\u0016J\u0015\u0010%\u001a\u00070\t\u00a2\u0006\u0002\b&2\u0006\u0010'\u001a\u00020\u0010H\u0016J\"\u0010(\u001a\f0\t\u00a2\u0006\u0002\b)\u00a2\u0006\u0002\b&2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\u0018H\u0016J\b\u0010,\u001a\u00020\u001bH\u0016J\u001a\u0010-\u001a\u00070\t\u00a2\u0006\u0002\b&2\u000b\u0010.\u001a\u00070\t\u00a2\u0006\u0002\b&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/zmlx/hg4idea/ignore/HgIgnoredFileContentProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getFileName", "", "Lorg/jetbrains/annotations/NonNls;", "buildIgnoreFileContent", "ignoreFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "ignoredFileProviders", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "(Lcom/intellij/openapi/vfs/VirtualFile;[Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;)Ljava/lang/String;", "getUntrackedFiles", "", "hgRepoRoot", "ignoreBeansToRelativePaths", "", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "untrackedFiles", "shouldIgnoreUnderDir", "", "ignoredBean", "vcsRoot", "vcsContextFactory", "Lcom/intellij/openapi/vcs/actions/VcsContextFactory;", "shouldIgnoreFile", "shouldIgnoreByMask", "buildUnignoreContent", "", "ignorePattern", "buildIgnoreGroupDescription", "Lcom/intellij/openapi/util/NlsSafe;", "ignoredFileProvider", "buildIgnoreEntryContent", "Lorg/jetbrains/annotations/Nullable;", "ignoreEntryRoot", "ignoredFileDescriptor", "supportIgnoreFileNotInVcsRoot", "prependCommentHashCharacterIfNeeded", "description", "intellij.vcs.hg"})
@SourceDebugExtension(value={"SMAP\nHgIgnoredFileContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HgIgnoredFileContentProvider.kt\norg/zmlx/hg4idea/ignore/HgIgnoredFileContentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n774#2:127\n865#2,2:128\n774#2:130\n865#2,2:131\n1563#2:133\n1634#2,3:134\n1761#2,3:137\n1761#2,3:140\n1761#2,3:143\n*S KotlinDebug\n*F\n+ 1 HgIgnoredFileContentProvider.kt\norg/zmlx/hg4idea/ignore/HgIgnoredFileContentProvider\n*L\n64#1:127\n64#1:128,2\n76#1:130\n76#1:131,2\n82#1:133\n82#1:134,3\n97#1:137,3\n107#1:140,3\n112#1:143,3\n*E\n"})
public final class HgIgnoredFileContentProvider
implements IgnoredFileContentProvider {
    @NotNull
    private final Project project;

    public HgIgnoredFileContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = HgVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        return vcsKey;
    }

    @NotNull
    public String getFileName() {
        return ".hgignore";
    }

    @NotNull
    public String buildIgnoreFileContent(@NotNull VirtualFile ignoreFileRoot, @NotNull IgnoredFileProvider[] ignoredFileProviders) {
        Intrinsics.checkNotNullParameter((Object)ignoreFileRoot, (String)"ignoreFileRoot");
        Intrinsics.checkNotNullParameter((Object)ignoredFileProviders, (String)"ignoredFileProviders");
        VirtualFile hgRepoRoot = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)ignoreFileRoot);
        if (hgRepoRoot == null || !Intrinsics.areEqual((Object)hgRepoRoot, (Object)ignoreFileRoot)) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        Set<VirtualFile> untrackedFiles = this.getUntrackedFiles(hgRepoRoot, ignoreFileRoot);
        if (untrackedFiles.isEmpty()) {
            return "";
        }
        for (IgnoredFileProvider provider : ignoredFileProviders) {
            String description;
            Set set = provider.getIgnoredFiles(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getIgnoredFiles(...)");
            List<String> ignoredFiles = this.ignoreBeansToRelativePaths(set, ignoreFileRoot, untrackedFiles);
            if (ignoredFiles.isEmpty()) continue;
            if (((CharSequence)content).length() > 0) {
                content.append(lineSeparator).append(lineSeparator);
            }
            Intrinsics.checkNotNullExpressionValue((Object)provider.getIgnoredGroupDescription(), (String)"getIgnoredGroupDescription(...)");
            if (!StringsKt.isBlank((CharSequence)description)) {
                content.append(this.buildIgnoreGroupDescription(provider));
                content.append(lineSeparator);
            }
            Iterable iterable = ignoredFiles;
            Intrinsics.checkNotNull((Object)lineSeparator);
            content.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)lineSeparator, null, null, (int)0, null, null, (int)62, null));
        }
        return ((CharSequence)content).length() > 0 ? "syntax: glob" + lineSeparator + lineSeparator + content : "";
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> getUntrackedFiles(VirtualFile hgRepoRoot, VirtualFile ignoreFileRoot) {
        Set set;
        try {
            void $this$filterTo$iv$iv;
            Collection<VirtualFile> collection = new HgStatusCommand.Builder(false).unknown(true).removed(true).build(this.project).getFiles(hgRepoRoot);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getFiles(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                if (!VfsUtil.isAncestor((VirtualFile)ignoreFileRoot, (VirtualFile)it, (boolean)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection2 = (List)destination$iv$iv;
            set = new HashSet(collection2);
        }
        catch (VcsException e) {
            HgIgnoredFileContentProviderKt.access$getLOG$p().warn("Cannot get untracked files: ", (Throwable)e);
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> ignoreBeansToRelativePaths(Iterable<? extends IgnoredFileDescriptor> $this$ignoreBeansToRelativePaths, VirtualFile ignoreFileRoot, Set<? extends VirtualFile> untrackedFiles) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IgnoredFileDescriptor ignoredBean;
        void $this$filterTo$iv$iv;
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)ignoreFileRoot);
        VcsContextFactory vcsContextFactory = VcsContextFactory.getInstance();
        Iterable $this$filter$iv = $this$ignoreBeansToRelativePaths;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ignoredBean = (IgnoredFileDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(switch (WhenMappings.$EnumSwitchMapping$0[ignoredBean.getType().ordinal()]) {
                case 1 -> {
                    Intrinsics.checkNotNull((Object)vcsContextFactory);
                    yield this.shouldIgnoreUnderDir(ignoredBean, untrackedFiles, ignoreFileRoot, vcsRoot, vcsContextFactory);
                }
                case 2 -> {
                    Intrinsics.checkNotNull((Object)vcsContextFactory);
                    yield this.shouldIgnoreFile(ignoredBean, untrackedFiles, ignoreFileRoot, vcsRoot, vcsContextFactory);
                }
                case 3 -> this.shouldIgnoreByMask(ignoredBean, untrackedFiles);
                default -> throw new NoWhenBranchMatchedException();
            })) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            ignoredBean = (IgnoredFileDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[ignoredBean.getType().ordinal()]) {
                case 3: {
                    String string2 = ignoredBean.getMask();
                    string = string2;
                    Intrinsics.checkNotNull((Object)string2);
                    break;
                }
                case 1: {
                    string = this.buildIgnoreEntryContent(ignoreFileRoot, ignoredBean);
                    break;
                }
                case 2: {
                    string = this.buildIgnoreEntryContent(ignoreFileRoot, ignoredBean);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreUnderDir(IgnoredFileDescriptor ignoredBean, Set<? extends VirtualFile> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile vcsRoot, VcsContextFactory vcsContextFactory) {
        VirtualFile it;
        String string;
        if (!FileUtil.exists((String)ignoredBean.getPath())) return false;
        Iterable $this$any$iv = untrackedFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (VirtualFile)element$iv;
            boolean bl = false;
            string = ignoredBean.getPath();
            Intrinsics.checkNotNull((Object)string);
        } while (!FileUtil.isAncestor((String)string, (String)it.getPath(), (boolean)true));
        boolean bl = true;
        if (!bl) return false;
        String string2 = ignoreFileRoot.getPath();
        String string3 = ignoredBean.getPath();
        Intrinsics.checkNotNull((Object)string3);
        if (!FileUtil.isAncestor((String)string2, (String)string3, (boolean)false)) return false;
        String string4 = ignoredBean.getPath();
        Intrinsics.checkNotNull((Object)string4);
        if (!Comparing.equal((Object)vcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(string4, true)))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreFile(IgnoredFileDescriptor ignoredBean, Set<? extends VirtualFile> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile vcsRoot, VcsContextFactory vcsContextFactory) {
        VirtualFile it;
        if (!FileUtil.exists((String)ignoredBean.getPath())) return false;
        Iterable $this$any$iv = untrackedFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (VirtualFile)element$iv;
            boolean bl = false;
        } while (!ignoredBean.matchesFile(it));
        boolean bl = true;
        if (!bl) return false;
        String string = ignoreFileRoot.getPath();
        String string2 = ignoredBean.getPath();
        Intrinsics.checkNotNull((Object)string2);
        if (!FileUtil.isAncestor((String)string, (String)string2, (boolean)false)) return false;
        String string3 = ignoredBean.getPath();
        Intrinsics.checkNotNull((Object)string3);
        if (!Comparing.equal((Object)vcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(string3, false)))) return false;
        return true;
    }

    private final boolean shouldIgnoreByMask(IgnoredFileDescriptor ignoredBean, Set<? extends VirtualFile> untrackedFiles) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = untrackedFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!ignoredBean.matchesFile(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public Void buildUnignoreContent(@NotNull String ignorePattern) {
        Intrinsics.checkNotNullParameter((Object)ignorePattern, (String)"ignorePattern");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String buildIgnoreGroupDescription(@NotNull IgnoredFileProvider ignoredFileProvider) {
        Intrinsics.checkNotNullParameter((Object)ignoredFileProvider, (String)"ignoredFileProvider");
        String string = ignoredFileProvider.getIgnoredGroupDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIgnoredGroupDescription(...)");
        return this.prependCommentHashCharacterIfNeeded(string);
    }

    @NotNull
    public String buildIgnoreEntryContent(@NotNull VirtualFile ignoreEntryRoot, @NotNull IgnoredFileDescriptor ignoredFileDescriptor) {
        Intrinsics.checkNotNullParameter((Object)ignoreEntryRoot, (String)"ignoreEntryRoot");
        Intrinsics.checkNotNullParameter((Object)ignoredFileDescriptor, (String)"ignoredFileDescriptor");
        String string = ignoreEntryRoot.getPath();
        String string2 = ignoredFileDescriptor.getPath();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = FileUtil.getRelativePath((String)string, (String)string2, (char)'/');
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    public boolean supportIgnoreFileNotInVcsRoot() {
        return false;
    }

    private final String prependCommentHashCharacterIfNeeded(String description) {
        return StringsKt.startsWith$default((String)description, (String)"#", (boolean)false, (int)2, null) ? description : "# " + description;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IgnoreSettingsType.values().length];
            try {
                nArray[IgnoreSettingsType.UNDER_DIR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IgnoreSettingsType.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IgnoreSettingsType.MASK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

