/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Hash;

final class StrippedLongToLongMap {
    private final long[] keys;
    private final long[] values;
    private final transient int mask;
    private transient boolean containsNullKey;
    private final int size;

    private StrippedLongToLongMap(int size, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (size < 0) {
            throw new IllegalArgumentException("The size number of elements must be non-negative");
        }
        this.size = size;
        int n = Hash.arraySize(size, loadFactor);
        this.mask = n - 1;
        this.keys = new long[n + 1];
        this.values = new long[this.keys.length + 1];
    }

    StrippedLongToLongMap(long[] metadata) {
        this(metadata.length / 2, 0.5f);
        for (int i = 0; i < metadata.length; i += 2) {
            this.add(metadata[i], metadata[i + 1]);
        }
    }

    private void add(long k, long v) {
        if (k == 0L) {
            if (this.containsNullKey) {
                return;
            }
            this.containsNullKey = true;
            this.values[this.keys.length] = v;
        } else {
            int index = (int)k & this.mask;
            long curr = this.keys[index];
            if (curr != 0L) {
                if (curr == k) {
                    return;
                }
                while ((curr = this.keys[index = index + 1 & this.mask]) != 0L) {
                    if (curr != k) continue;
                    return;
                }
            }
            this.keys[index] = k;
            this.values[index] = v;
        }
    }

    public long get(long k) {
        if (k == 0L) {
            return this.containsNullKey ? this.values[this.keys.length] : -1L;
        }
        int index = (int)k & this.mask;
        long curr = this.keys[index];
        if (curr == 0L) {
            return -1L;
        }
        if (k == curr) {
            return this.values[index];
        }
        do {
            if ((curr = this.keys[index = index + 1 & this.mask]) != 0L) continue;
            return -1L;
        } while (k != curr);
        return this.values[index];
    }

    public int size() {
        return this.size;
    }
}

