/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.backend;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.backend.BackendRecentFileEventsModel;
import com.intellij.platform.recentFiles.backend.BackendRecentFilesModel;
import com.intellij.platform.recentFiles.shared.FileChangeKind;
import com.intellij.platform.recentFiles.shared.RecentFileKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/recentFiles/backend/BackendRecentFileEventsController;", "", "<init>", "()V", "applyRelevantEventsToModel", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "changeKind", "Lcom/intellij/platform/recentFiles/shared/FileChangeKind;", "project", "Lcom/intellij/openapi/project/Project;", "updateAllExistingFilesInModel", "intellij.platform.recentFiles.backend"})
@SourceDebugExtension(value={"SMAP\nBackendRecentFileEventsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRecentFileEventsController.kt\ncom/intellij/platform/recentFiles/backend/BackendRecentFileEventsController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,34:1\n774#2:35\n865#2,2:36\n23#3:38\n23#3:39\n67#3,4:40\n*S KotlinDebug\n*F\n+ 1 BackendRecentFileEventsController.kt\ncom/intellij/platform/recentFiles/backend/BackendRecentFileEventsController\n*L\n20#1:35\n20#1:36,2\n21#1:38\n22#1:39\n22#1:40,4\n*E\n"})
public final class BackendRecentFileEventsController {
    @NotNull
    public static final BackendRecentFileEventsController INSTANCE = new BackendRecentFileEventsController();

    private BackendRecentFileEventsController() {
    }

    /*
     * WARNING - void declaration
     */
    public final void applyRelevantEventsToModel(@NotNull List<? extends VirtualFile> files, @NotNull FileChangeKind changeKind, @NotNull Project project) {
        void $this$trace$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)changeKind, (String)"changeKind");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(!it.isDirectory())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filesWithoutDirectories = (List)destination$iv$iv;
        BackendRecentFileEventsController $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BackendRecentFileEventsController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Trying to apply changes for " + filesWithoutDirectories.size() + " files out of total " + files.size() + " virtual files to the model, change kind: " + changeKind);
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(BackendRecentFileEventsController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        $this$thisLogger$iv = logger2;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            void var14_15 = $this$trace$iv;
            boolean bl = false;
            var14_15.trace("Files to apply changes for: " + CollectionsKt.joinToString$default((Iterable)filesWithoutDirectories, null, null, null, (int)0, null, BackendRecentFileEventsController::applyRelevantEventsToModel$lambda$1$0, (int)31, null));
        }
        BackendRecentFileEventsModel.Companion.getInstance(project).scheduleApplyBackendChanges(changeKind, filesWithoutDirectories);
    }

    public final void updateAllExistingFilesInModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set filesToUpdate = new LinkedHashSet();
        for (RecentFileKind filesKind : RecentFileKind.getEntries()) {
            CollectionsKt.addAll((Collection)filesToUpdate, (Iterable)BackendRecentFilesModel.Companion.getInstance(project).getFilesByKind(filesKind));
        }
        BackendRecentFileEventsModel.Companion.getInstance(project).scheduleApplyBackendChanges(FileChangeKind.UPDATED, filesToUpdate);
    }

    private static final CharSequence applyRelevantEventsToModel$lambda$1$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

