/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BytesWritable
extends BinaryComparable
implements WritableComparable<BinaryComparable> {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int LENGTH_BYTES = 4;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int size;
    private byte[] bytes;

    public BytesWritable() {
        this.bytes = EMPTY_BYTES;
        this.size = 0;
    }

    public BytesWritable(byte[] bytes) {
        this(bytes, bytes.length);
    }

    public BytesWritable(byte[] bytes, int length) {
        this.bytes = bytes;
        this.size = length;
    }

    public byte[] copyBytes() {
        return Arrays.copyOf(this.bytes, this.size);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Deprecated
    public byte[] get() {
        return this.getBytes();
    }

    @Override
    public int getLength() {
        return this.size;
    }

    @Deprecated
    public int getSize() {
        return this.getLength();
    }

    public void setSize(int size) {
        if (size > this.getCapacity()) {
            long newSize = Math.min(0x7FFFFFF7L, 3L * (long)size / 2L);
            this.setCapacity((int)newSize);
        }
        this.size = size;
    }

    public int getCapacity() {
        return this.bytes.length;
    }

    public void setCapacity(int capacity) {
        if (capacity != this.getCapacity()) {
            this.size = Math.min(this.size, capacity);
            this.bytes = Arrays.copyOf(this.bytes, capacity);
        }
    }

    public void set(BytesWritable newData) {
        this.set(newData.bytes, 0, newData.size);
    }

    public void set(byte[] newData, int offset, int length) {
        this.setSize(0);
        this.setSize(length);
        System.arraycopy(newData, offset, this.bytes, 0, this.size);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.setSize(0);
        this.setSize(in.readInt());
        in.readFully(this.bytes, 0, this.size);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size);
        out.write(this.bytes, 0, this.size);
    }

    @Override
    public boolean equals(Object right_obj) {
        if (right_obj instanceof BytesWritable) {
            return super.equals(right_obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return IntStream.range(0, this.size).mapToObj(idx -> String.format("%02x", this.bytes[idx])).collect(Collectors.joining(" "));
    }

    static {
        WritableComparator.define(BytesWritable.class, new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(BytesWritable.class);
        }

        @Override
        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return Comparator.compareBytes(b1, s1 + 4, l1 - 4, b2, s2 + 4, l2 - 4);
        }
    }
}

