/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.math.ec.WNafUtil;
import org.bouncycastle.util.BigIntegers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DhKeyGeneratorHelper {
    static final DhKeyGeneratorHelper INSTANCE = new DhKeyGeneratorHelper();

    private DhKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(DhParameters dhParameters, SecureRandom secureRandom) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n = dhParameters.getL();
        if (n != 0) {
            BigInteger bigInteger3;
            int n2 = n >>> 2;
            while (WNafUtil.getNafWeight(bigInteger3 = BigIntegers.createRandomBigInteger(n, secureRandom).setBit(n - 1)) < n2) {
            }
            return bigInteger3;
        }
        BigInteger bigInteger4 = BigIntegers.TWO;
        int n3 = dhParameters.getM();
        if (n3 != 0) {
            bigInteger4 = BigIntegers.ONE.shiftLeft(n3 - 1);
        }
        if ((bigInteger2 = dhParameters.getQ()) == null) {
            bigInteger2 = dhParameters.getP();
        }
        BigInteger bigInteger5 = bigInteger2.subtract(BigIntegers.TWO);
        int n4 = bigInteger5.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(bigInteger = BigIntegers.createRandomInRange(bigInteger4, bigInteger5, secureRandom)) < n4) {
        }
        return bigInteger;
    }

    BigInteger calculatePublic(DhParameters dhParameters, BigInteger bigInteger) {
        return dhParameters.getG().modPow(bigInteger, dhParameters.getP());
    }
}

