/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.util.Bits;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.codec.BinaryDocValuesSub;
import org.opensearch.neuralsearch.sparse.codec.SparseBinaryDocValues;
import org.opensearch.neuralsearch.sparse.codec.SparseBinaryDocValuesPassThrough;
import org.opensearch.neuralsearch.sparse.common.MergeStateFacade;

public class SparseDocValuesReader
extends EmptyDocValuesProducer {
    private final MergeStateFacade mergeStateFacade;

    public SparseDocValuesReader(MergeStateFacade mergeStateFacade) {
        this.mergeStateFacade = mergeStateFacade;
    }

    public BinaryDocValues getBinary(FieldInfo field) throws IOException {
        long totalLiveDocs = 0L;
        int size = this.mergeStateFacade.getDocValuesProducers().length;
        ArrayList<BinaryDocValuesSub> subs = new ArrayList<BinaryDocValuesSub>(size);
        for (int i = 0; i < size; ++i) {
            DocValuesProducer docValuesProducer = this.mergeStateFacade.getDocValuesProducers()[i];
            if (docValuesProducer == null) continue;
            BinaryDocValues values = null;
            FieldInfo readerFieldInfo = this.mergeStateFacade.getFieldInfos()[i].fieldInfo(field.getName());
            if (readerFieldInfo != null && readerFieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                values = docValuesProducer.getBinary(readerFieldInfo);
            }
            if (values == null) continue;
            CacheKey key = null;
            if (values instanceof SparseBinaryDocValuesPassThrough) {
                SparseBinaryDocValuesPassThrough sparseBinaryDocValuesPassThrough = (SparseBinaryDocValuesPassThrough)values;
                key = new CacheKey(sparseBinaryDocValuesPassThrough.getSegmentInfo(), field);
            }
            totalLiveDocs += this.getLiveDocsCount(values, this.mergeStateFacade.getLiveDocs()[i]);
            values = this.mergeStateFacade.getLiveDocs()[i] != null ? docValuesProducer.getBinary(readerFieldInfo) : values;
            subs.add(new BinaryDocValuesSub(this.mergeStateFacade.getDocMaps()[i], values, key));
        }
        if (subs.isEmpty()) {
            return new SparseBinaryDocValues(null);
        }
        return new SparseBinaryDocValues((DocIDMerger<BinaryDocValuesSub>)DocIDMerger.of(subs, (boolean)this.mergeStateFacade.needIndexSort())).setTotalLiveDocs(totalLiveDocs);
    }

    private long getLiveDocsCount(BinaryDocValues binaryDocValues, Bits liveDocsBits) throws IOException {
        long liveDocs = 0L;
        if (liveDocsBits != null) {
            int docId = binaryDocValues.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                if (liveDocsBits.get(docId)) {
                    ++liveDocs;
                }
                docId = binaryDocValues.nextDoc();
            }
        } else {
            liveDocs = binaryDocValues.cost();
        }
        return liveDocs;
    }

    @Generated
    public MergeStateFacade getMergeStateFacade() {
        return this.mergeStateFacade;
    }
}

