/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.Arrays;
import fleet.fastutil.longs.LongArrays;
import fleet.fastutil.longs.LongList;
import fleet.fastutil.longs.LongListExtensionsKt;
import fleet.fastutil.longs.MutableLongList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0018\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 <2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001<B\u0019\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\rB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\u000eB\u0017\b\u0016\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\b\u0010\u0012B\u0011\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\u0014B\u0011\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0011H\u0016J\u0018\u0010#\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0019\u0010$\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u0011H\u0096\u0002J\b\u0010%\u001a\u00020\u001cH\u0016J\u0011\u0010&\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000bH\u0096\u0002J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u000bH\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010)\u001a\u00020\u001c2\b\b\u0002\u0010*\u001a\u00020\u000bJ\b\u0010+\u001a\u00020\u001cH\u0016J(\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J&\u0010.\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0018\u00100\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000bH\u0016J(\u00102\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0013\u00103\u001a\u00020\u00072\b\u00104\u001a\u0004\u0018\u000105H\u0096\u0002J\u0011\u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u0003H\u0096\u0002J\b\u00108\u001a\u00020\u000bH\u0016J\u0006\u00109\u001a\u00020\u0000J\b\u0010:\u001a\u00020;H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u0016\u00a8\u0006="}, d2={"Lfleet/fastutil/longs/LongArrayList;", "Lfleet/fastutil/longs/MutableLongList;", "", "Lfleet/fastutil/longs/LongList;", "a", "", "wrapped", "", "<init>", "([JZ)V", "offset", "", "length", "([JII)V", "()V", "i", "", "", "(Ljava/util/Iterator;)V", "list", "(Lfleet/fastutil/longs/LongList;)V", "capacity", "(I)V", "size", "getSize", "()I", "setSize", "initArrayFromCapacity", "", "elements", "ensureCapacity", "grow", "add", "index", "element", "addAll", "set", "clear", "get", "removeAt", "resize", "trim", "n", "sort", "toArray", "from", "getElements", "targetList", "removeElements", "to", "addElements", "equals", "o", "", "compareTo", "l", "hashCode", "clone", "toString", "", "Companion", "fleet.fastutil"})
public final class LongArrayList
implements MutableLongList,
Comparable<LongList> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long[] a;
    private int size;
    public static final int DEFAULT_INITIAL_CAPACITY = 10;

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    private LongArrayList(long[] a, boolean wrapped) {
        this.a = a;
    }

    public LongArrayList(@NotNull long[] a, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this(length);
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        ArraysKt.copyInto((long[])a, (long[])lArray, (int)0, (int)offset, (int)(offset + length));
        this.setSize(length);
    }

    public /* synthetic */ LongArrayList(long[] lArray, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = lArray.length;
        }
        this(lArray, n, n2);
    }

    private final void initArrayFromCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = capacity == 0 ? new long[]{} : new long[capacity];
    }

    public LongArrayList() {
        this.a = LongArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY();
    }

    public LongArrayList(@NotNull Iterator<Long> i2) {
        Intrinsics.checkNotNullParameter(i2, (String)"i");
        this();
        while (i2.hasNext()) {
            this.add(((Number)i2.next()).longValue());
        }
    }

    public LongArrayList(@NotNull LongList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this();
        IntRange intRange = LongListExtensionsKt.getIndices(list);
        int i2 = intRange.getFirst();
        int n = intRange.getLast();
        if (i2 <= n) {
            while (true) {
                this.add(list.get(i2));
                if (i2 == n) break;
                ++i2;
            }
        }
    }

    public LongArrayList(int capacity) {
        this.initArrayFromCapacity(capacity);
    }

    @NotNull
    public final long[] elements() {
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        return lArray;
    }

    public final void ensureCapacity(int capacity) {
        block9: {
            block8: {
                long[] lArray;
                long[] lArray2 = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                    lArray2 = null;
                }
                if (capacity <= lArray2.length) break block8;
                long[] lArray3 = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                    lArray3 = null;
                }
                if (!java.util.Arrays.equals(lArray = lArray3, LongArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY()) || capacity > 10) break block9;
            }
            return;
        }
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        this.a = LongArrays.INSTANCE.ensureCapacity(lArray, capacity, this.getSize());
        int n = this.getSize();
        long[] lArray4 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray4 = null;
        }
        if (!(n <= lArray4.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private final void grow(int capacity) {
        long[] lArray;
        int capacity2 = capacity;
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        if (capacity2 <= lArray2.length) {
            return;
        }
        long[] lArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray3 = null;
        }
        if (!java.util.Arrays.equals(lArray = lArray3, LongArrays.INSTANCE.getDEFAULT_EMPTY_ARRAY())) {
            long[] lArray4 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray4 = null;
            }
            int n = lArray4.length;
            long[] lArray5 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray5 = null;
            }
            int n2 = n + (lArray5.length >> 1);
            int n3 = 0x7FFFFFF7;
            capacity2 = Math.max(Math.min(n2, n3), capacity2);
        } else if (capacity2 < 10) {
            capacity2 = 10;
        }
        long[] lArray6 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray6 = null;
        }
        this.a = LongArrays.INSTANCE.forceCapacity(lArray6, capacity2, this.getSize());
        int n = this.getSize();
        long[] lArray7 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray7 = null;
        }
        if (!(n <= lArray7.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public void add(int index, long element) {
        LongListExtensionsKt.ensureIndex(this, index);
        this.grow(this.getSize() + 1);
        if (index != this.getSize()) {
            long[] lArray = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray = null;
            }
            long[] lArray2 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray2 = null;
            }
            ArraysKt.copyInto((long[])lArray, (long[])lArray2, (int)(index + 1), (int)index, (int)this.getSize());
        }
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        lArray[index] = element;
        int n = this.getSize();
        this.setSize(n + 1);
        int n2 = this.getSize();
        long[] lArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray3 = null;
        }
        if (!(n2 <= lArray3.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public void add(long element) {
        this.grow(this.getSize() + 1);
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        int n = this.getSize();
        this.setSize(n + 1);
        lArray[n] = element;
        int n2 = this.getSize();
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        if (!(n2 <= lArray2.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public boolean addAll(int index, @NotNull LongList elements) {
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
        LongListExtensionsKt.ensureIndex(this, index);
        int index2 = index;
        int n = elements.getSize();
        if (n == 0) {
            return false;
        }
        this.grow(this.getSize() + n);
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        ArraysKt.copyInto((long[])lArray, (long[])lArray2, (int)(index2 + n), (int)index2, (int)(index2 + (this.getSize() - index2)));
        int i2 = LongListExtensionsKt.getIndices(elements).getFirst();
        this.setSize(this.getSize() + n);
        while (n-- != 0) {
            long[] lArray3 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray3 = null;
            }
            lArray3[index2++] = elements.get(i2++);
        }
        int n2 = this.getSize();
        long[] lArray4 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray4 = null;
        }
        if (!(n2 <= lArray4.length)) {
            throw new IllegalStateException("Check failed.");
        }
        return true;
    }

    @Override
    public long set(int index, long element) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is out of bounds for size (" + this.getSize() + ")");
        }
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        long old = lArray[index];
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        lArray2[index] = element;
        return old;
    }

    @Override
    public void clear() {
        this.setSize(0);
        int n = this.getSize();
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        if (!(n <= lArray.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Override
    public long get(int index) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.getSize());
        }
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        return lArray[index];
    }

    @Override
    public long removeAt(int index) {
        if (index >= this.getSize() || index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") out of bounds for length (" + this.getSize() + ")");
        }
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        long[] a = lArray;
        long old = a[index];
        this.setSize(this.getSize() - 1);
        if (index != this.getSize()) {
            ArraysKt.copyInto((long[])a, (long[])a, (int)index, (int)(index + 1), (int)(this.getSize() + 1));
        }
        if (!(this.getSize() <= a.length)) {
            throw new IllegalStateException("Check failed.");
        }
        return old;
    }

    @Override
    public void resize(int size) {
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        if (size > lArray.length) {
            long[] lArray2 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray2 = null;
            }
            this.a = LongArrays.INSTANCE.forceCapacity(lArray2, size, this.getSize());
        }
        if (size > this.getSize()) {
            long[] lArray3 = this.a;
            if (this.a == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                lArray3 = null;
            }
            ArraysKt.fill((long[])lArray3, (long)0L, (int)this.getSize(), (int)size);
        }
        this.setSize(size);
    }

    public final void trim(int n) {
        block9: {
            block8: {
                long[] lArray = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                    lArray = null;
                }
                if (n >= lArray.length) break block8;
                int n2 = this.getSize();
                long[] lArray2 = this.a;
                if (this.a == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"a");
                    lArray2 = null;
                }
                if (n2 != lArray2.length) break block9;
            }
            return;
        }
        long[] t2 = new long[Math.max(n, this.getSize())];
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        ArraysKt.copyInto((long[])lArray, (long[])t2, (int)0, (int)0, (int)this.getSize());
        this.a = t2;
        int n3 = this.getSize();
        long[] lArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray3 = null;
        }
        if (!(n3 <= lArray3.length)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public static /* synthetic */ void trim$default(LongArrayList longArrayList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        longArrayList.trim(n);
    }

    @Override
    public void sort() {
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        ArraysKt.sort((long[])lArray, (int)0, (int)this.getSize());
    }

    @Override
    @NotNull
    public long[] toArray(int from, @NotNull long[] a, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        LongListExtensionsKt.ensureIndex(this, from);
        Arrays.INSTANCE.ensureOffsetLength(a, offset, length);
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        ArraysKt.copyInto((long[])lArray, (long[])a, (int)offset, (int)from, (int)(from + length));
        return a;
    }

    public final void getElements(int from, @NotNull LongArrayList targetList, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)targetList, (String)"targetList");
        LongListExtensionsKt.ensureIndex(this, from);
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        Arrays.INSTANCE.ensureOffsetLength(lArray, offset, length);
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        long[] lArray3 = targetList.a;
        if (targetList.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray3 = null;
        }
        ArraysKt.copyInto((long[])lArray2, (long[])lArray3, (int)offset, (int)from, (int)(from + length));
    }

    @Override
    public void removeElements(int from, int to) {
        Arrays.INSTANCE.ensureFromTo(this.getSize(), from, to);
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        ArraysKt.copyInto((long[])lArray, (long[])lArray2, (int)from, (int)to, (int)this.getSize());
        this.setSize(this.getSize() - (to - from));
    }

    @Override
    public void addElements(int index, @NotNull long[] a, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        LongListExtensionsKt.ensureIndex(this, index);
        Arrays.INSTANCE.ensureOffsetLength(a, offset, length);
        this.grow(this.getSize() + length);
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        long[] lArray2 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray2 = null;
        }
        ArraysKt.copyInto((long[])lArray, (long[])lArray2, (int)(index + length), (int)index, (int)(index + (this.getSize() - index)));
        long[] lArray3 = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray3 = null;
        }
        ArraysKt.copyInto((long[])a, (long[])lArray3, (int)index, (int)offset, (int)(offset + length));
        this.setSize(this.getSize() + length);
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof LongList && this.compareTo((LongList)o) == 0;
    }

    @Override
    public int compareTo(@NotNull LongList l) {
        int i2;
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        int s1 = LongListExtensionsKt.length(this);
        int s2 = LongListExtensionsKt.length(l);
        long e1 = 0L;
        long e2 = 0L;
        int r2 = 0;
        for (i2 = 0; i2 < s1 && i2 < s2; ++i2) {
            e1 = this.get(i2);
            e2 = l.get(i2);
            int n = e1 > e2 ? 1 : (r2 = e1 < e2 ? -1 : 0);
            if (r2 == 0) continue;
            return r2;
        }
        return i2 < s2 ? -1 : (i2 < s1 ? 1 : 0);
    }

    public int hashCode() {
        int i2 = LongListExtensionsKt.getIndices(this).getFirst();
        int h = 1;
        int s = this.getSize();
        while (s-- != 0) {
            int k = (int)this.get(i2++);
            h = 31 * h + k;
        }
        return h;
    }

    @NotNull
    public final LongArrayList clone() {
        LongArrayList clone = new LongArrayList();
        clone.setSize(this.getSize());
        long[] lArray = this.a;
        if (this.a == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"a");
            lArray = null;
        }
        long[] lArray2 = lArray;
        long[] lArray3 = java.util.Arrays.copyOf(lArray2, lArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray3, (String)"copyOf(...)");
        clone.a = lArray3;
        return clone;
    }

    @NotNull
    public String toString() {
        StringBuilder s = new StringBuilder();
        int i2 = LongListExtensionsKt.getIndices(this).getFirst();
        int n = this.getSize();
        int k = 0;
        boolean first2 = true;
        s.append("[");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            k = (int)this.get(i2);
            ++i2;
            s.append(String.valueOf(k));
        }
        s.append("]");
        String string2 = s.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public /* synthetic */ LongArrayList(long[] a, boolean wrapped, DefaultConstructorMarker $constructor_marker) {
        this(a, wrapped);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0007J\u0012\u0010\u000b\u001a\u00020\u00072\n\u0010\f\u001a\u00020\t\"\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lfleet/fastutil/longs/LongArrayList$Companion;", "", "<init>", "()V", "DEFAULT_INITIAL_CAPACITY", "", "wrap", "Lfleet/fastutil/longs/LongArrayList;", "a", "", "length", "of", "init", "", "fleet.fastutil"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LongArrayList wrap(@NotNull long[] a) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return this.wrap(a, a.length);
        }

        @NotNull
        public final LongArrayList wrap(@NotNull long[] a, int length) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            if (length > a.length) {
                throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a.length + ")");
            }
            LongArrayList l = new LongArrayList(a, true, null);
            l.setSize(length);
            return l;
        }

        @NotNull
        public final LongArrayList of() {
            return new LongArrayList();
        }

        @NotNull
        public final LongArrayList of(long ... init) {
            Intrinsics.checkNotNullParameter((Object)init, (String)"init");
            return this.wrap(init);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

