# Copyright 2022-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.2

EAPI=8

CRATES="
	adler2@2.0.0
	aho-corasick@1.1.3
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	ansi_colours@1.2.3
	ansi_term@0.12.1
	anstream@0.6.18
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-wincon@3.0.7
	anstyle@1.0.10
	anyhow@1.0.98
	approx@0.5.1
	autocfg@1.4.0
	base64@0.22.1
	bat@0.24.0
	bincode@1.3.3
	bitflags@1.3.2
	bitflags@2.9.0
	box_drawing@0.1.2
	bstr@1.12.0
	bumpalo@3.17.0
	by_address@1.2.1
	bytelines@2.5.0
	bytemuck@1.22.0
	bytesize@1.3.3
	cc@1.2.20
	cfg-if@1.0.0
	cfg_aliases@0.2.1
	chrono-humanize@0.2.3
	chrono@0.4.40
	clap@4.5.37
	clap_builder@4.5.37
	clap_complete@4.5.47
	clap_derive@4.5.32
	clap_lex@0.7.4
	clircle@0.4.0
	colorchoice@1.0.3
	console@0.15.11
	content_inspector@0.2.4
	core-foundation-sys@0.8.7
	crc32fast@1.4.2
	ctrlc@3.4.6
	deranged@0.4.0
	dirs-sys@0.4.1
	dirs@5.0.1
	displaydoc@0.2.5
	either@1.15.0
	encode_unicode@1.0.0
	encoding_rs@0.8.35
	equivalent@1.0.2
	errno@0.3.11
	etcetera@0.8.0
	fast-srgb8@1.0.0
	flate2@1.1.1
	fnv@1.0.7
	form_urlencoded@1.2.1
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-macro@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-timer@3.0.3
	futures-util@0.3.31
	futures@0.3.31
	getrandom@0.2.16
	getrandom@0.3.2
	git2@0.20.1
	glob@0.3.2
	globset@0.4.16
	grep-cli@0.1.11
	hashbrown@0.15.2
	heck@0.5.0
	home@0.5.11
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.63
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.1
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.1
	icu_properties@1.5.1
	icu_properties_data@1.5.1
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	idna@1.0.3
	idna_adapter@1.2.0
	indexmap@2.9.0
	insta@1.43.0
	is_terminal_polyfill@1.70.1
	itertools@0.10.5
	itoa@1.0.15
	jobserver@0.1.33
	js-sys@0.3.77
	lazy_static@1.5.0
	libc@0.2.172
	libgit2-sys@0.18.1+1.9.0
	libredox@0.1.3
	libz-sys@1.1.22
	linked-hash-map@0.5.6
	linux-raw-sys@0.9.4
	litemap@0.7.5
	log@0.4.27
	memchr@2.7.4
	miniz_oxide@0.8.8
	mio@1.0.3
	nix@0.29.0
	ntapi@0.4.1
	nu-ansi-term@0.49.0
	num-conv@0.1.0
	num-traits@0.2.19
	once_cell@1.21.3
	onig@6.4.0
	onig_sys@69.8.1
	option-ext@0.2.0
	palette@0.7.6
	palette_derive@0.7.6
	path_abs@0.5.1
	pathdiff@0.2.3
	percent-encoding@2.3.1
	phf@0.11.3
	phf_generator@0.11.3
	phf_macros@0.11.3
	phf_shared@0.11.3
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	pkg-config@0.3.32
	plist@1.7.1
	powerfmt@0.2.0
	proc-macro-crate@3.3.0
	proc-macro2@1.0.95
	quick-xml@0.32.0
	quote@1.0.40
	r-efi@5.2.0
	rand@0.8.5
	rand_core@0.6.4
	redox_users@0.4.6
	regex-automata@0.4.9
	regex-syntax@0.8.5
	regex@1.11.1
	relative-path@1.9.3
	rgb@0.8.50
	rstest@0.21.0
	rstest_macros@0.21.0
	rustc_version@0.4.1
	rustix@1.0.5
	rustversion@1.0.20
	ryu@1.0.20
	same-file@1.0.6
	semver@1.0.26
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.140
	serde_yaml@0.9.34+deprecated
	shell-words@1.1.0
	shlex@1.3.0
	similar@2.7.0
	siphasher@1.0.1
	slab@0.4.9
	smallvec@1.15.0
	smol_str@0.1.24
	stable_deref_trait@1.2.0
	std_prelude@0.2.12
	strsim@0.11.1
	syn@2.0.100
	synstructure@0.13.1
	syntect@5.2.0
	sysinfo@0.29.11
	termcolor@1.4.1
	terminal-colorsaurus@0.4.8
	terminal-trx@0.2.4
	terminal_size@0.4.2
	thiserror-impl@1.0.69
	thiserror@1.0.69
	time-core@0.1.4
	time-macros@0.2.22
	time@0.3.41
	tinystr@0.7.6
	toml_datetime@0.6.9
	toml_edit@0.22.25
	unicode-ident@1.0.18
	unicode-segmentation@1.12.0
	unicode-width@0.1.12
	unicode-width@0.2.0
	unsafe-libyaml@0.2.11
	url@2.5.4
	utf16_iter@1.0.5
	utf8_iter@1.0.4
	utf8parse@0.2.2
	vcpkg@0.2.15
	walkdir@2.5.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasi@0.14.2+wasi-0.2.4
	wasm-bindgen-backend@0.2.100
	wasm-bindgen-macro-support@0.2.100
	wasm-bindgen-macro@0.2.100
	wasm-bindgen-shared@0.2.100
	wasm-bindgen@0.2.100
	wild@2.2.1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.61.0
	windows-implement@0.60.0
	windows-interface@0.59.1
	windows-link@0.1.1
	windows-result@0.3.2
	windows-strings@0.4.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.7.7
	wit-bindgen-rt@0.39.0
	write16@1.0.0
	writeable@0.5.5
	xdg@2.5.2
	xterm-color@1.0.1
	yaml-rust@0.4.5
	yoke-derive@0.7.5
	yoke@0.7.5
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerovec-derive@0.10.3
	zerovec@0.10.4
"
RUST_MIN_VER="1.81"
inherit cargo shell-completion

DESCRIPTION="A syntax-highlighting pager for git"
HOMEPAGE="https://github.com/dandavison/delta"
SRC_URI="
	https://github.com/dandavison/delta/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}/${P/git-/}"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD LGPL-3+ MIT MPL-2.0 Unicode-3.0"
SLOT="0"
KEYWORDS="amd64 ~arm ~arm64 ~ppc64 ~riscv"

BDEPEND="
	virtual/pkgconfig
"
DEPEND="
	dev-libs/libgit2:0/1.9
	dev-libs/oniguruma:=
	sys-libs/zlib
"
RDEPEND="
	${DEPEND}
	!app-text/delta
"

QA_FLAGS_IGNORED="usr/bin/delta"

pkg_setup() {
	rust_pkg_setup
}

src_prepare() {
	default

	# unpin crates, and allow newer libgit2
	rm Cargo.lock || die
	sed -i -e '/git2/s:0\.18\.2:*:' Cargo.toml || die

	export LIBGIT2_NO_VENDOR=1
	export PKG_CONFIG_ALLOW_CROSS=1
	export RUSTONIG_SYSTEM_LIBONIG=1
}

src_install() {
	cargo_src_install

	# Completions
	newbashcomp "${S}"/etc/completion/completion.bash delta
	newzshcomp "${S}"/etc/completion/completion.zsh _delta
	newfishcomp "${S}"/etc/completion/completion.fish delta.fish
}
