# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# Note: Please bump in sync with dev-libs/libxslt

GNOME_ORG_MODULE="libxml2"
inherit autotools gnome.org multilib-minimal

XSTS_HOME="http://www.w3.org/XML/2004/xml-schema-test-suite"
XSTS_NAME_1="xmlschema2002-01-16"
XSTS_NAME_2="xmlschema2004-01-14"
XSTS_TARBALL_1="xsts-2002-01-16.tar.gz"
XSTS_TARBALL_2="xsts-2004-01-14.tar.gz"
XMLCONF_TARBALL="xmlts20130923.tar.gz"

DESCRIPTION="XML C parser and toolkit"
HOMEPAGE="https://gitlab.gnome.org/GNOME/libxml2/-/wikis/home"
SRC_URI+="
	test? (
		${XSTS_HOME}/${XSTS_NAME_1}/${XSTS_TARBALL_1}
		${XSTS_HOME}/${XSTS_NAME_2}/${XSTS_TARBALL_2}
		https://www.w3.org/XML/Test/${XMLCONF_TARBALL}
	)
"
S="${WORKDIR}/libxml2-${PV%_rc*}"

LICENSE="MIT"
SLOT="2"
KEYWORDS="~alpha ~amd64 ~arm ~arm64 ~hppa ~loong ~m68k ~mips ~ppc ~ppc64 ~riscv ~s390 ~sparc ~x86 ~amd64-linux ~x86-linux ~arm64-macos ~ppc-macos ~x64-macos ~x64-solaris"

IUSE="icu lzma readline test"
RESTRICT="!test? ( test )"

RDEPEND="
	!<dev-libs/libxml2-2.14
	virtual/libiconv
	>=sys-libs/zlib-1.2.8-r1:=[${MULTILIB_USEDEP}]
	icu? ( >=dev-libs/icu-51.2-r1:=[${MULTILIB_USEDEP}] )
	lzma? ( >=app-arch/xz-utils-5.0.5-r1:=[${MULTILIB_USEDEP}] )
	readline? ( sys-libs/readline:= )
"
DEPEND="${RDEPEND}"
BDEPEND="virtual/pkgconfig"

PATCHES=(
	"${FILESDIR}"/libxml2-2.12.9-icu-pkgconfig.patch
)

src_unpack() {
	local tarname=libxml2-${PV/_rc/-rc}.tar.xz

	# ${A} isn't used to avoid unpacking of test tarballs into ${WORKDIR},
	# as they are needed as tarballs in ${S}/xstc instead and not unpacked
	unpack ${tarname}

	if [[ -n ${PATCHSET_VERSION} ]] ; then
		unpack libxml2-${PATCHSET_VERSION}.tar.xz
	fi

	cd "${S}" || die

	if use test ; then
		cp "${DISTDIR}/${XSTS_TARBALL_1}" \
			"${DISTDIR}/${XSTS_TARBALL_2}" \
			"${S}"/xstc/ \
			|| die "Failed to install test tarballs"
		unpack ${XMLCONF_TARBALL}
	fi
}

src_prepare() {
	default

	# Please do not remove, as else we get references to PORTAGE_TMPDIR
	# in /usr/lib/python?.?/site-packages/libxml2mod.la among things.
	#elibtoolize

	eautoreconf
}

multilib_src_configure() {
	ECONF_SOURCE="${S}" econf \
		$(use_with icu) \
		$(use_with lzma) \
		--disable-static \
		$(multilib_native_use_with readline) \
		$(multilib_native_use_with readline history) \
		--without-python \
		--with-legacy \
		"$@"
}

multilib_src_test() {
	ln -s "${S}"/xmlconf || die

	emake check
}

multilib_src_install() {
	emake DESTDIR="${D}" install

	rm "${ED}"/usr/$(get_libdir)/libxml2.so || die

	rm -r "${ED}"/usr/$(get_libdir)/cmake/libxml2 || die
	rm -r "${ED}"/usr/$(get_libdir)/pkgconfig/libxml-2.0.pc || die
}

multilib_src_install_all() {
	einstalldocs

	# Don't conflict with >=dev-libs/libxml2-2.14
	rm -r "${ED}"/usr/bin/xml2-config || die
	rm -r "${ED}"/usr/bin/xmllint || die
	rm -r "${ED}"/usr/bin/xmlcatalog || die
	rm -r "${ED}"/usr/share/doc/${PF}/xmlcatalog.html || die
	rm -r "${ED}"/usr/share/doc/${PF}/xmllint.html || die
	rm -r "${ED}"/usr/include/ ||  die
	rm -r "${ED}"/usr/share/man/ || die
	rm -r "${ED}"/usr/share/gtk-doc/ || die
	rm -r "${ED}"/usr/share/aclocal/libxml.m4 || die

	rm -rf "${ED}"/usr/share/doc/libxml2-${PVR}/examples || die
	rm -rf "${ED}"/usr/share/doc/libxml2-${PVR}/python/examples || die

	rm -rf "${ED}"/usr/share/doc/libxml2-python-${PVR} || die

	find "${ED}" -name '*.la' -delete || die
}

pkg_postinst() {
	# We don't want to do the xmlcatalog during stage1, as xmlcatalog will not
	# be in / and stage1 builds to ROOT=/tmp/stage1root. This fixes bug #208887.
	if [[ -n "${ROOT}" ]]; then
		elog "Skipping XML catalog creation for stage building (bug #208887)."
	else
		# Need an XML catalog, so no-one writes to a non-existent one
		CATALOG="${EROOT}/etc/xml/catalog"

		# We don't want to clobber an existing catalog though,
		# only ensure that one is there
		# <obz@gentoo.org>
		if [[ ! -e "${CATALOG}" ]]; then
			[[ -d "${EROOT}/etc/xml" ]] || mkdir -p "${EROOT}/etc/xml"
			"${EPREFIX}"/usr/bin/xmlcatalog --create > "${CATALOG}"
			einfo "Created XML catalog in ${CATALOG}"
		fi
	fi
}
