# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.6.7.9999
#hackport: flags: -llvm

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="Efficient algorithms for vector arrays"
HOMEPAGE="https://github.com/erikd/vector-algorithms/"
SRC_URI="https://hackage.haskell.org/package/${P}/${P}.tar.gz"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="+bench +boundschecks internalchecks +properties unsafechecks"

RDEPEND=">=dev-haskell/primitive-0.3:=[profile?] <dev-haskell/primitive-0.8:=[profile?]
	>=dev-haskell/tagged-0.4:=[profile?] <dev-haskell/tagged-0.9:=[profile?]
	>=dev-haskell/vector-0.6:=[profile?] <dev-haskell/vector-0.13:=[profile?]
	>=dev-lang/ghc-7.4.1:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-1.10
	test? ( properties? ( >dev-haskell/quickcheck-2.9 <dev-haskell/quickcheck-2.15 ) )
"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag bench bench) \
		$(cabal_flag boundschecks boundschecks) \
		$(cabal_flag internalchecks internalchecks) \
		--flag=-llvm \
		$(cabal_flag properties properties) \
		$(cabal_flag unsafechecks unsafechecks)
}
