/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha3

import (
	resourcev1alpha3 "k8s.io/api/resource/v1alpha3"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// DeviceTaintRuleLister helps list DeviceTaintRules.
// All objects returned here must be treated as read-only.
type DeviceTaintRuleLister interface {
	// List lists all DeviceTaintRules in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*resourcev1alpha3.DeviceTaintRule, err error)
	// Get retrieves the DeviceTaintRule from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*resourcev1alpha3.DeviceTaintRule, error)
	DeviceTaintRuleListerExpansion
}

// deviceTaintRuleLister implements the DeviceTaintRuleLister interface.
type deviceTaintRuleLister struct {
	listers.ResourceIndexer[*resourcev1alpha3.DeviceTaintRule]
}

// NewDeviceTaintRuleLister returns a new DeviceTaintRuleLister.
func NewDeviceTaintRuleLister(indexer cache.Indexer) DeviceTaintRuleLister {
	return &deviceTaintRuleLister{listers.New[*resourcev1alpha3.DeviceTaintRule](indexer, resourcev1alpha3.Resource("devicetaintrule"))}
}
