/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;

public class InvertedRenderableModuleResult
extends AbstractRenderableModuleResult {
    private final ResolvedDependencyResult dependencyResult;

    public InvertedRenderableModuleResult(ResolvedComponentResult module) {
        super(module);
        this.dependencyResult = null;
    }

    public InvertedRenderableModuleResult(ResolvedDependencyResult dependencyResult) {
        super(dependencyResult.getFrom());
        this.dependencyResult = dependencyResult;
    }

    public Set<RenderableDependency> getChildren() {
        LinkedHashMap<ComponentIdentifier, InvertedRenderableModuleResult> children = new LinkedHashMap<ComponentIdentifier, InvertedRenderableModuleResult>();
        for (ResolvedDependencyResult dependent : this.module.getDependents()) {
            InvertedRenderableModuleResult child = new InvertedRenderableModuleResult(dependent);
            if (children.containsKey(child.getId())) continue;
            children.put(child.getId(), child);
        }
        return new LinkedHashSet<RenderableDependency>(children.values());
    }

    @Override
    public String getDescription() {
        if (this.dependencyResult != null && !this.exactMatch(this.dependencyResult.getRequested(), this.dependencyResult.getSelected().getId())) {
            return "(requested " + this.dependencyResult.getRequested() + ")";
        }
        return null;
    }
}

