// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package awsquerycompatibleiface provides an interface to enable mocking the AWSQuery Compatible Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package awsquerycompatibleiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/model/api/codegentest/service/awsquerycompatible"
)

// AwsQueryCompatibleAPI provides an interface to enable mocking the
// awsquerycompatible.AwsQueryCompatible service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWSQuery Compatible Service.
//	func myFunc(svc awsquerycompatibleiface.AwsQueryCompatibleAPI) bool {
//	    // Make svc.CreateQueue request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := awsquerycompatible.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockAwsQueryCompatibleClient struct {
//	    awsquerycompatibleiface.AwsQueryCompatibleAPI
//	}
//	func (m *mockAwsQueryCompatibleClient) CreateQueue(input *awsquerycompatible.CreateQueueInput) (*awsquerycompatible.CreateQueueOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockAwsQueryCompatibleClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AwsQueryCompatibleAPI interface {
	CreateQueue(*awsquerycompatible.CreateQueueInput) (*awsquerycompatible.CreateQueueOutput, error)
	CreateQueueWithContext(aws.Context, *awsquerycompatible.CreateQueueInput, ...request.Option) (*awsquerycompatible.CreateQueueOutput, error)
	CreateQueueRequest(*awsquerycompatible.CreateQueueInput) (*request.Request, *awsquerycompatible.CreateQueueOutput)
}

var _ AwsQueryCompatibleAPI = (*awsquerycompatible.AwsQueryCompatible)(nil)
