/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Color;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.jemmy.util.AbstractTextStyleChooser;

public class TextStyleChooser
extends AbstractTextStyleChooser {
    Boolean bold = null;
    Boolean italic = null;
    Boolean strike = null;
    Boolean understrike = null;
    Integer fontSize = null;
    String fontFamily = null;
    Integer alignment = null;
    Color background = null;
    Color foreground = null;

    public void setBold(boolean bold) {
        this.bold = bold ? Boolean.TRUE : Boolean.FALSE;
    }

    public void unsetBold() {
        this.bold = null;
    }

    public void setItalic(boolean italic) {
        this.italic = italic ? Boolean.TRUE : Boolean.FALSE;
    }

    public void unsetItalic() {
        this.italic = null;
    }

    public void setStrike(boolean strike) {
        this.strike = strike ? Boolean.TRUE : Boolean.FALSE;
    }

    public void unsetStrike() {
        this.strike = null;
    }

    public void setUnderstrike(boolean understrike) {
        this.understrike = understrike ? Boolean.TRUE : Boolean.FALSE;
    }

    public void unsetUnderstrike() {
        this.understrike = null;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = new Integer(fontSize);
    }

    public void unsetFontSize() {
        this.fontSize = null;
    }

    public void setAlignment(int alignment) {
        this.alignment = new Integer(alignment);
    }

    public void unsetAlignment() {
        this.alignment = null;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public void unsetFontFamily() {
        this.fontFamily = null;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void unsetBackground() {
        this.background = null;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void unsetForeground() {
        this.foreground = null;
    }

    @Override
    public boolean checkElement(StyledDocument doc, Element element, int offset) {
        if (this.bold != null && StyleConstants.isBold(element.getAttributes()) != this.bold) {
            return false;
        }
        if (this.italic != null && StyleConstants.isItalic(element.getAttributes()) != this.italic) {
            return false;
        }
        if (this.strike != null && StyleConstants.isStrikeThrough(element.getAttributes()) != this.strike) {
            return false;
        }
        if (this.understrike != null && StyleConstants.isUnderline(element.getAttributes()) != this.understrike) {
            return false;
        }
        if (this.fontSize != null && StyleConstants.getFontSize(element.getAttributes()) != this.fontSize) {
            return false;
        }
        if (this.alignment != null && StyleConstants.getAlignment(element.getAttributes()) != this.alignment) {
            return false;
        }
        if (this.fontFamily != null && !StyleConstants.getFontFamily(element.getAttributes()).equals(this.fontFamily)) {
            return false;
        }
        if (this.background != null && !StyleConstants.getBackground(element.getAttributes()).equals(this.background)) {
            return false;
        }
        return this.foreground == null || StyleConstants.getForeground(element.getAttributes()).equals(this.foreground);
    }

    @Override
    public String getDescription() {
        String result = "";
        if (this.bold != null) {
            result = result + (this.bold != false ? "" : "not ") + "bold, ";
        }
        if (this.italic != null) {
            result = result + (this.italic != false ? "" : "not ") + "italic, ";
        }
        if (this.strike != null) {
            result = result + (this.strike != false ? "" : "not ") + "strike, ";
        }
        if (this.understrike != null) {
            result = result + (this.understrike != false ? "" : "not ") + "understrike, ";
        }
        if (this.fontSize != null) {
            result = result + this.fontSize.toString() + " size, ";
        }
        if (this.alignment != null) {
            result = result + this.alignment.toString() + " alignment, ";
        }
        if (this.fontFamily != null) {
            result = result + "\"" + this.fontFamily + "\" font family, ";
        }
        if (this.background != null) {
            result = result + this.background.toString() + " background, ";
        }
        if (this.foreground != null) {
            result = result + this.foreground.toString() + " foreground, ";
        }
        if (result.equals("")) {
            result = "any, ";
        }
        return result.substring(0, result.length() - 2) + " font";
    }
}

