// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package iottwinmakeriface provides an interface to enable mocking the AWS IoT TwinMaker service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package iottwinmakeriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/iottwinmaker"
)

// IoTTwinMakerAPI provides an interface to enable mocking the
// iottwinmaker.IoTTwinMaker service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS IoT TwinMaker.
//	func myFunc(svc iottwinmakeriface.IoTTwinMakerAPI) bool {
//	    // Make svc.BatchPutPropertyValues request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := iottwinmaker.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockIoTTwinMakerClient struct {
//	    iottwinmakeriface.IoTTwinMakerAPI
//	}
//	func (m *mockIoTTwinMakerClient) BatchPutPropertyValues(input *iottwinmaker.BatchPutPropertyValuesInput) (*iottwinmaker.BatchPutPropertyValuesOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockIoTTwinMakerClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type IoTTwinMakerAPI interface {
	BatchPutPropertyValues(*iottwinmaker.BatchPutPropertyValuesInput) (*iottwinmaker.BatchPutPropertyValuesOutput, error)
	BatchPutPropertyValuesWithContext(aws.Context, *iottwinmaker.BatchPutPropertyValuesInput, ...request.Option) (*iottwinmaker.BatchPutPropertyValuesOutput, error)
	BatchPutPropertyValuesRequest(*iottwinmaker.BatchPutPropertyValuesInput) (*request.Request, *iottwinmaker.BatchPutPropertyValuesOutput)

	CreateComponentType(*iottwinmaker.CreateComponentTypeInput) (*iottwinmaker.CreateComponentTypeOutput, error)
	CreateComponentTypeWithContext(aws.Context, *iottwinmaker.CreateComponentTypeInput, ...request.Option) (*iottwinmaker.CreateComponentTypeOutput, error)
	CreateComponentTypeRequest(*iottwinmaker.CreateComponentTypeInput) (*request.Request, *iottwinmaker.CreateComponentTypeOutput)

	CreateEntity(*iottwinmaker.CreateEntityInput) (*iottwinmaker.CreateEntityOutput, error)
	CreateEntityWithContext(aws.Context, *iottwinmaker.CreateEntityInput, ...request.Option) (*iottwinmaker.CreateEntityOutput, error)
	CreateEntityRequest(*iottwinmaker.CreateEntityInput) (*request.Request, *iottwinmaker.CreateEntityOutput)

	CreateScene(*iottwinmaker.CreateSceneInput) (*iottwinmaker.CreateSceneOutput, error)
	CreateSceneWithContext(aws.Context, *iottwinmaker.CreateSceneInput, ...request.Option) (*iottwinmaker.CreateSceneOutput, error)
	CreateSceneRequest(*iottwinmaker.CreateSceneInput) (*request.Request, *iottwinmaker.CreateSceneOutput)

	CreateWorkspace(*iottwinmaker.CreateWorkspaceInput) (*iottwinmaker.CreateWorkspaceOutput, error)
	CreateWorkspaceWithContext(aws.Context, *iottwinmaker.CreateWorkspaceInput, ...request.Option) (*iottwinmaker.CreateWorkspaceOutput, error)
	CreateWorkspaceRequest(*iottwinmaker.CreateWorkspaceInput) (*request.Request, *iottwinmaker.CreateWorkspaceOutput)

	DeleteComponentType(*iottwinmaker.DeleteComponentTypeInput) (*iottwinmaker.DeleteComponentTypeOutput, error)
	DeleteComponentTypeWithContext(aws.Context, *iottwinmaker.DeleteComponentTypeInput, ...request.Option) (*iottwinmaker.DeleteComponentTypeOutput, error)
	DeleteComponentTypeRequest(*iottwinmaker.DeleteComponentTypeInput) (*request.Request, *iottwinmaker.DeleteComponentTypeOutput)

	DeleteEntity(*iottwinmaker.DeleteEntityInput) (*iottwinmaker.DeleteEntityOutput, error)
	DeleteEntityWithContext(aws.Context, *iottwinmaker.DeleteEntityInput, ...request.Option) (*iottwinmaker.DeleteEntityOutput, error)
	DeleteEntityRequest(*iottwinmaker.DeleteEntityInput) (*request.Request, *iottwinmaker.DeleteEntityOutput)

	DeleteScene(*iottwinmaker.DeleteSceneInput) (*iottwinmaker.DeleteSceneOutput, error)
	DeleteSceneWithContext(aws.Context, *iottwinmaker.DeleteSceneInput, ...request.Option) (*iottwinmaker.DeleteSceneOutput, error)
	DeleteSceneRequest(*iottwinmaker.DeleteSceneInput) (*request.Request, *iottwinmaker.DeleteSceneOutput)

	DeleteWorkspace(*iottwinmaker.DeleteWorkspaceInput) (*iottwinmaker.DeleteWorkspaceOutput, error)
	DeleteWorkspaceWithContext(aws.Context, *iottwinmaker.DeleteWorkspaceInput, ...request.Option) (*iottwinmaker.DeleteWorkspaceOutput, error)
	DeleteWorkspaceRequest(*iottwinmaker.DeleteWorkspaceInput) (*request.Request, *iottwinmaker.DeleteWorkspaceOutput)

	GetComponentType(*iottwinmaker.GetComponentTypeInput) (*iottwinmaker.GetComponentTypeOutput, error)
	GetComponentTypeWithContext(aws.Context, *iottwinmaker.GetComponentTypeInput, ...request.Option) (*iottwinmaker.GetComponentTypeOutput, error)
	GetComponentTypeRequest(*iottwinmaker.GetComponentTypeInput) (*request.Request, *iottwinmaker.GetComponentTypeOutput)

	GetEntity(*iottwinmaker.GetEntityInput) (*iottwinmaker.GetEntityOutput, error)
	GetEntityWithContext(aws.Context, *iottwinmaker.GetEntityInput, ...request.Option) (*iottwinmaker.GetEntityOutput, error)
	GetEntityRequest(*iottwinmaker.GetEntityInput) (*request.Request, *iottwinmaker.GetEntityOutput)

	GetPropertyValue(*iottwinmaker.GetPropertyValueInput) (*iottwinmaker.GetPropertyValueOutput, error)
	GetPropertyValueWithContext(aws.Context, *iottwinmaker.GetPropertyValueInput, ...request.Option) (*iottwinmaker.GetPropertyValueOutput, error)
	GetPropertyValueRequest(*iottwinmaker.GetPropertyValueInput) (*request.Request, *iottwinmaker.GetPropertyValueOutput)

	GetPropertyValueHistory(*iottwinmaker.GetPropertyValueHistoryInput) (*iottwinmaker.GetPropertyValueHistoryOutput, error)
	GetPropertyValueHistoryWithContext(aws.Context, *iottwinmaker.GetPropertyValueHistoryInput, ...request.Option) (*iottwinmaker.GetPropertyValueHistoryOutput, error)
	GetPropertyValueHistoryRequest(*iottwinmaker.GetPropertyValueHistoryInput) (*request.Request, *iottwinmaker.GetPropertyValueHistoryOutput)

	GetPropertyValueHistoryPages(*iottwinmaker.GetPropertyValueHistoryInput, func(*iottwinmaker.GetPropertyValueHistoryOutput, bool) bool) error
	GetPropertyValueHistoryPagesWithContext(aws.Context, *iottwinmaker.GetPropertyValueHistoryInput, func(*iottwinmaker.GetPropertyValueHistoryOutput, bool) bool, ...request.Option) error

	GetScene(*iottwinmaker.GetSceneInput) (*iottwinmaker.GetSceneOutput, error)
	GetSceneWithContext(aws.Context, *iottwinmaker.GetSceneInput, ...request.Option) (*iottwinmaker.GetSceneOutput, error)
	GetSceneRequest(*iottwinmaker.GetSceneInput) (*request.Request, *iottwinmaker.GetSceneOutput)

	GetWorkspace(*iottwinmaker.GetWorkspaceInput) (*iottwinmaker.GetWorkspaceOutput, error)
	GetWorkspaceWithContext(aws.Context, *iottwinmaker.GetWorkspaceInput, ...request.Option) (*iottwinmaker.GetWorkspaceOutput, error)
	GetWorkspaceRequest(*iottwinmaker.GetWorkspaceInput) (*request.Request, *iottwinmaker.GetWorkspaceOutput)

	ListComponentTypes(*iottwinmaker.ListComponentTypesInput) (*iottwinmaker.ListComponentTypesOutput, error)
	ListComponentTypesWithContext(aws.Context, *iottwinmaker.ListComponentTypesInput, ...request.Option) (*iottwinmaker.ListComponentTypesOutput, error)
	ListComponentTypesRequest(*iottwinmaker.ListComponentTypesInput) (*request.Request, *iottwinmaker.ListComponentTypesOutput)

	ListComponentTypesPages(*iottwinmaker.ListComponentTypesInput, func(*iottwinmaker.ListComponentTypesOutput, bool) bool) error
	ListComponentTypesPagesWithContext(aws.Context, *iottwinmaker.ListComponentTypesInput, func(*iottwinmaker.ListComponentTypesOutput, bool) bool, ...request.Option) error

	ListEntities(*iottwinmaker.ListEntitiesInput) (*iottwinmaker.ListEntitiesOutput, error)
	ListEntitiesWithContext(aws.Context, *iottwinmaker.ListEntitiesInput, ...request.Option) (*iottwinmaker.ListEntitiesOutput, error)
	ListEntitiesRequest(*iottwinmaker.ListEntitiesInput) (*request.Request, *iottwinmaker.ListEntitiesOutput)

	ListEntitiesPages(*iottwinmaker.ListEntitiesInput, func(*iottwinmaker.ListEntitiesOutput, bool) bool) error
	ListEntitiesPagesWithContext(aws.Context, *iottwinmaker.ListEntitiesInput, func(*iottwinmaker.ListEntitiesOutput, bool) bool, ...request.Option) error

	ListScenes(*iottwinmaker.ListScenesInput) (*iottwinmaker.ListScenesOutput, error)
	ListScenesWithContext(aws.Context, *iottwinmaker.ListScenesInput, ...request.Option) (*iottwinmaker.ListScenesOutput, error)
	ListScenesRequest(*iottwinmaker.ListScenesInput) (*request.Request, *iottwinmaker.ListScenesOutput)

	ListScenesPages(*iottwinmaker.ListScenesInput, func(*iottwinmaker.ListScenesOutput, bool) bool) error
	ListScenesPagesWithContext(aws.Context, *iottwinmaker.ListScenesInput, func(*iottwinmaker.ListScenesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*iottwinmaker.ListTagsForResourceInput) (*iottwinmaker.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *iottwinmaker.ListTagsForResourceInput, ...request.Option) (*iottwinmaker.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*iottwinmaker.ListTagsForResourceInput) (*request.Request, *iottwinmaker.ListTagsForResourceOutput)

	ListWorkspaces(*iottwinmaker.ListWorkspacesInput) (*iottwinmaker.ListWorkspacesOutput, error)
	ListWorkspacesWithContext(aws.Context, *iottwinmaker.ListWorkspacesInput, ...request.Option) (*iottwinmaker.ListWorkspacesOutput, error)
	ListWorkspacesRequest(*iottwinmaker.ListWorkspacesInput) (*request.Request, *iottwinmaker.ListWorkspacesOutput)

	ListWorkspacesPages(*iottwinmaker.ListWorkspacesInput, func(*iottwinmaker.ListWorkspacesOutput, bool) bool) error
	ListWorkspacesPagesWithContext(aws.Context, *iottwinmaker.ListWorkspacesInput, func(*iottwinmaker.ListWorkspacesOutput, bool) bool, ...request.Option) error

	TagResource(*iottwinmaker.TagResourceInput) (*iottwinmaker.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *iottwinmaker.TagResourceInput, ...request.Option) (*iottwinmaker.TagResourceOutput, error)
	TagResourceRequest(*iottwinmaker.TagResourceInput) (*request.Request, *iottwinmaker.TagResourceOutput)

	UntagResource(*iottwinmaker.UntagResourceInput) (*iottwinmaker.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *iottwinmaker.UntagResourceInput, ...request.Option) (*iottwinmaker.UntagResourceOutput, error)
	UntagResourceRequest(*iottwinmaker.UntagResourceInput) (*request.Request, *iottwinmaker.UntagResourceOutput)

	UpdateComponentType(*iottwinmaker.UpdateComponentTypeInput) (*iottwinmaker.UpdateComponentTypeOutput, error)
	UpdateComponentTypeWithContext(aws.Context, *iottwinmaker.UpdateComponentTypeInput, ...request.Option) (*iottwinmaker.UpdateComponentTypeOutput, error)
	UpdateComponentTypeRequest(*iottwinmaker.UpdateComponentTypeInput) (*request.Request, *iottwinmaker.UpdateComponentTypeOutput)

	UpdateEntity(*iottwinmaker.UpdateEntityInput) (*iottwinmaker.UpdateEntityOutput, error)
	UpdateEntityWithContext(aws.Context, *iottwinmaker.UpdateEntityInput, ...request.Option) (*iottwinmaker.UpdateEntityOutput, error)
	UpdateEntityRequest(*iottwinmaker.UpdateEntityInput) (*request.Request, *iottwinmaker.UpdateEntityOutput)

	UpdateScene(*iottwinmaker.UpdateSceneInput) (*iottwinmaker.UpdateSceneOutput, error)
	UpdateSceneWithContext(aws.Context, *iottwinmaker.UpdateSceneInput, ...request.Option) (*iottwinmaker.UpdateSceneOutput, error)
	UpdateSceneRequest(*iottwinmaker.UpdateSceneInput) (*request.Request, *iottwinmaker.UpdateSceneOutput)

	UpdateWorkspace(*iottwinmaker.UpdateWorkspaceInput) (*iottwinmaker.UpdateWorkspaceOutput, error)
	UpdateWorkspaceWithContext(aws.Context, *iottwinmaker.UpdateWorkspaceInput, ...request.Option) (*iottwinmaker.UpdateWorkspaceOutput, error)
	UpdateWorkspaceRequest(*iottwinmaker.UpdateWorkspaceInput) (*request.Request, *iottwinmaker.UpdateWorkspaceOutput)
}

var _ IoTTwinMakerAPI = (*iottwinmaker.IoTTwinMaker)(nil)
