package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchGetEdgeInstanceChannel invokes the iot.BatchGetEdgeInstanceChannel API synchronously
func (client *Client) BatchGetEdgeInstanceChannel(request *BatchGetEdgeInstanceChannelRequest) (response *BatchGetEdgeInstanceChannelResponse, err error) {
	response = CreateBatchGetEdgeInstanceChannelResponse()
	err = client.DoAction(request, response)
	return
}

// BatchGetEdgeInstanceChannelWithChan invokes the iot.BatchGetEdgeInstanceChannel API asynchronously
func (client *Client) BatchGetEdgeInstanceChannelWithChan(request *BatchGetEdgeInstanceChannelRequest) (<-chan *BatchGetEdgeInstanceChannelResponse, <-chan error) {
	responseChan := make(chan *BatchGetEdgeInstanceChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchGetEdgeInstanceChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchGetEdgeInstanceChannelWithCallback invokes the iot.BatchGetEdgeInstanceChannel API asynchronously
func (client *Client) BatchGetEdgeInstanceChannelWithCallback(request *BatchGetEdgeInstanceChannelRequest, callback func(response *BatchGetEdgeInstanceChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchGetEdgeInstanceChannelResponse
		var err error
		defer close(result)
		response, err = client.BatchGetEdgeInstanceChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchGetEdgeInstanceChannelRequest is the request struct for api BatchGetEdgeInstanceChannel
type BatchGetEdgeInstanceChannelRequest struct {
	*requests.RpcRequest
	DriverId      string    `position:"Query" name:"DriverId"`
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	InstanceId    string    `position:"Query" name:"InstanceId"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
	ChannelIds    *[]string `position:"Query" name:"ChannelIds"  type:"Repeated"`
}

// BatchGetEdgeInstanceChannelResponse is the response struct for api BatchGetEdgeInstanceChannel
type BatchGetEdgeInstanceChannelResponse struct {
	*responses.BaseResponse
	RequestId    string                            `json:"RequestId" xml:"RequestId"`
	Success      bool                              `json:"Success" xml:"Success"`
	Code         string                            `json:"Code" xml:"Code"`
	ErrorMessage string                            `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInBatchGetEdgeInstanceChannel `json:"Data" xml:"Data"`
}

// CreateBatchGetEdgeInstanceChannelRequest creates a request to invoke BatchGetEdgeInstanceChannel API
func CreateBatchGetEdgeInstanceChannelRequest() (request *BatchGetEdgeInstanceChannelRequest) {
	request = &BatchGetEdgeInstanceChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchGetEdgeInstanceChannel", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchGetEdgeInstanceChannelResponse creates a response to parse from BatchGetEdgeInstanceChannel response
func CreateBatchGetEdgeInstanceChannelResponse() (response *BatchGetEdgeInstanceChannelResponse) {
	response = &BatchGetEdgeInstanceChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
